#include	"multi_forward.h"


int	portSet(void)
{
	struct	addrinfo	hints;
	int	err;
	int	yes = 1;
	char	PORT[10];
	int	ret;
	time_t	atime;

	// Monitor	
        memset (&hints, 0x00, sizeof(hints));
        hints.ai_socktype = SOCK_DGRAM;
        hints.ai_family = AF_INET;
        hints.ai_flags = AI_PASSIVE;
	hints.ai_protocol = 17;
        ret = sprintf (PORT, "%d", multi_port);
	PORT[ret] = 0x00;
        if ((err = getaddrinfo (NULL, PORT, &hints, &multi_serv)) != 0)
        {
        	fprintf (log_file, "%24.24s getaddrinfo error (monitor port:%d) %s\n",
                	ctime(&atime), multi_port, gai_strerror(err));
                multi_port = 0;
                fflush (log_file);
	}
        else
        {
        	if ((multi_sd = socket (multi_serv->ai_family, multi_serv->ai_socktype, multi_serv->ai_protocol)) < 0)
                {
                	time(&atime);
                        fprintf (log_file, "%24.24s Multi Socket not open. Already used this port:%d\n", ctime(&atime), multi_port);
                        fflush (log_file);
                        multi_port = 0;
                        freeaddrinfo (multi_serv);
			close (multi_sd);
			multi_sd = 0;
			return FALSE;
		}
                else
                {
               		if (setsockopt (multi_sd, SOL_SOCKET, SO_REUSEADDR, (const char *)&yes, sizeof(yes)))
                        {
                        	time(&atime);
                                fprintf (log_file, "%24.24s error setsock opt on MONITOR_PORT\n", 
					ctime(&atime));
                                fflush (log_file);
                                multi_port = 0;
                                freeaddrinfo (multi_serv);
                                close (multi_sd);
                                multi_sd = 0;
				return FALSE;
			}
                        else
                        {
				time (&atime);
                       		if (bind (multi_sd, multi_serv->ai_addr, multi_serv->ai_addrlen) != 0)
                                {
                                        fprintf (log_file, "%24.24s error bind on MONITOR_PORT %s\n", 
						ctime(&atime), strerror(errno));
                                        fflush (log_file);
                                        multi_port = 0;
					freeaddrinfo (multi_serv);
					return FALSE;
                                }
                                else
                                {
                                       	FD_SET (multi_sd, &read_save);
                                        fprintf (log_file, "%24.24s Monitor Port %d open.\n",
                                             		ctime(&atime), multi_port);
                                        fflush (log_file);
                                }
                        }
		}
	}

        if (http_port > 0)
        {
                memset (&hints, 0x00, sizeof(hints));
                hints.ai_socktype = SOCK_STREAM;
                hints.ai_family = PF_INET;
                hints.ai_flags = AI_PASSIVE;
		hints.ai_protocol = TCP;
                ret = sprintf (PORT, "%d", http_port);
		PORT[ret] = 0x00;
                if ((err = getaddrinfo (NULL, PORT, &hints, &http_serv)) != 0)
                {
                        fprintf (log_file, "%24.24s getaddrinfo error (http port:%d) %s\n",
                                ctime(&atime), http_port, gai_strerror(err));
                        http_port = 0;
                        fflush (log_file);
                }
                else
                {
                        if ((http_sd = socket (http_serv->ai_family, http_serv->ai_socktype, http_serv->ai_protocol)) < 0)
                        {
                                time(&atime);
                                fprintf (log_file, "%24.24s HTTP TCP Socket not open. Already used this port:%d\n", ctime(&atime), http_port);
                                fflush (log_file);
                                http_port = 0;
                                freeaddrinfo (http_serv);
                                close (http_sd);
                                http_sd = 0;
                        }
                        else
                        {
                                if (setsockopt (http_sd, SOL_SOCKET, SO_REUSEADDR, (const char *)&yes, sizeof(yes)))
                                {
                                        time(&atime);
                                        fprintf (log_file, "%24.24s error setsock opt on HTTP_PORT\n", ctime(&atime));
                                        fflush (log_file);
                                        http_port = 0;
                                        freeaddrinfo (http_serv);
                                        close (http_sd);
                                        http_sd = 0;
                                }
                                else
                                {
                                        if (bind (http_sd, http_serv->ai_addr, http_serv->ai_addrlen) != 0)
                                        {
                                                time (&atime);
                                                fprintf (log_file, "%24.24s error bind on HTTP_PORT %s\n", 
							ctime(&atime), strerror(errno));
                                                fflush (log_file);
                                                http_port = 0;
                                        }
                                        else
                                        {
                                                if (listen (http_sd, 5))
                                                {
                                                        time (&atime);
                                                        fprintf (log_file, "%24.24s error listen on HTTP_PORT %s\n",
                                                                                ctime(&atime), strerror(errno));
                                                        http_port = 0;
                                                        freeaddrinfo (http_serv);
                                                        fflush (log_file);
                                                }
                                                else
                                                {
                                                        FD_SET (http_sd, &read_save);
                                                        fprintf (log_file, "%24.24s HTTP Port %d open.\n",
                                                                        ctime(&atime), http_port);
                                                        fflush (log_file);
							cpu_fd = open ("/proc/stat", O_RDONLY);
                                                }
                                        }
                                }
                        }
                }
	}

	// upnp	
        memset (&hints, 0x00, sizeof(hints));
        hints.ai_socktype = SOCK_DGRAM;
        hints.ai_family = AF_INET;
        hints.ai_flags = AI_PASSIVE;
	hints.ai_protocol = 17;
        if ((err = getaddrinfo (NULL, "1900", &hints, &upnp_serv)) != 0)
        {
        	fprintf (log_file, "%24.24s getaddrinfo error (upnp port:%d) %s\n",
                	ctime(&atime), multi_port, gai_strerror(err));
                fflush (log_file);
	}
        else
        {
        	if ((upnp_udp_sd = socket (upnp_serv->ai_family, upnp_serv->ai_socktype, upnp_serv->ai_protocol)) < 0)
                {
                	time(&atime);
                        fprintf (log_file, "%24.24s upnp Socket not open. Already used this port:%d\n", ctime(&atime), multi_port);
                        fflush (log_file);
                        freeaddrinfo (upnp_serv);
			close (upnp_udp_sd);
			upnp_udp_sd = 0;
			return FALSE;
		}
                else
                {
               		if (setsockopt (upnp_udp_sd, SOL_SOCKET, SO_BROADCAST, (const char *)&yes, sizeof(yes)))
                        {
                        	time(&atime);
                                fprintf (log_file, "%24.24s error setsock opt on upnp portT\n", 
					ctime(&atime));
                                fflush (log_file);
                                freeaddrinfo (upnp_serv);
                                close (upnp_udp_sd);
                                upnp_udp_sd = 0;
				return FALSE;
			}
                        else
                        {
				time (&atime);
                       		if (bind (upnp_udp_sd, upnp_serv->ai_addr, upnp_serv->ai_addrlen) != 0)
                                {
                                        fprintf (log_file, "%24.24s error bind on upnp port  %s\n", 
						ctime(&atime), strerror(errno));
                                        fflush (log_file);
					freeaddrinfo (upnp_serv);
					return FALSE;
                                }
                                else
                                {
                                       	FD_SET (upnp_udp_sd, &read_save);
                                        fprintf (log_file, "%24.24s upnp port %d open.\n",
                                             		ctime(&atime), 1900);
                                        fflush (log_file);
                                }
                        }
		}
	}
                memset (&hints, 0x00, sizeof(hints));
                hints.ai_socktype = SOCK_DGRAM;
                hints.ai_family = PF_INET;

                if ((err = getaddrinfo ("239.255.255.250", "1900", &hints, &upnp_sock)) != 0)
                {
                        time (&cur_time);
                        fprintf (log_file, "%24.24s getaddrinfo error(upnp sock) %s\n",
                                ctime(&cur_time), gai_strerror(err));
                        fprintf (log_file, "%24.24s upnp : 239.255.255.250\n", ctime(&cur_time));
                        fflush (log_file);
                }
	return TRUE;
}

