/*
	D-STAR RF header and Voice packet
	
	Auth:	Satoshi Yasuda 7m3tjz/ad6gz
*/


struct	dstar_packet
{
	char	id[4];	/* DSTR */
	unsigned char	m[2];		// sequence 
	unsigned char	sr;		// GW ->   0x73 (s)     GW <- 0x72 (r)
	unsigned char	c;		// data 0x11  voice 0x12
	unsigned char	l[2];		// length  header 0x0030  voice 0x0013 last 0x0016
	struct
	{
		unsigned char	FrameType;	// data 0x40  voice 0x20
		unsigned char	dst_rpt_id;
		unsigned char	src_rpt_id;
		unsigned char	src_term_id;
		unsigned char	FrameID[2];
		unsigned char	FrameSeq;	// header 0x80  last frame | 0x40
	} trunk;
	union
	{
                struct
                {
                        char    flag[3];
                        unsigned char    rpt2[8];
                        unsigned char    rpt1[8];
                        unsigned char    urcall[8];
                        unsigned char    mycall[8];
                        unsigned char    mycall_ex[4];
                        unsigned char   crc[2];
                        unsigned char	ip[4];
                        unsigned char	port[2];
                } header;
		struct
		{
			char	voice[9];
			char	slowdata[3];
			unsigned char	ip[4];
			unsigned char	port[2];
		} voice;
		struct
		{
			char	voice[9];
			char	slowdata[3];
			char	dummy[3];
			unsigned char	ip[4];
			unsigned char	port[2];
		} last_voice;
	} body;
			
};

struct  icom_inet_packet
{
        char    id[4];  /* DSVT */
        char    type;           // header 0x10   voice 0x20
        char    resv[3];
        struct
        {
                unsigned char   FrameType;      // data 0x40  voice 0x20
                unsigned char   dst_rpt_id;
                unsigned char   src_rpt_id;
                unsigned char   src_term_id;
                unsigned char   FrameID[2];
                unsigned char   FrameSeq;       // header 0x80  last frame | 0x40
        } trunk;
        union
        {
                struct
                {
                        char    flag[3];
                        char    rpt2[8];
                        char    rpt1[8];
                        char    urcall[8];
                        char    mycall[8];
                        char    mycall_ex[4];
                        unsigned char   crc[2];
                } header;
                struct
                {
                        char    voice[9];
                        char    slowdata[3];
                } voice;
        } body;

};
