#include	"multi_forward.h"

void    send_upnp_http(void);
int	open_upnp_http(void);
void    send_upnp_port_info(void);
void	send_upnp_port_add(void);
void	send_upnp_port_del(void);
void    read_upnp_http(void);
void    upnp_msearch_set (void);
void    read_upnp_info(void);
void    read_upnp_port_add(void);
void	read_upnp_port_del(void);

enum {
	UPNP_IDLE = 0,
	UPNP_SEND_MSEARCH_GATEWAY,
	UPNP_RECV_MSEARCH_GATEWAY,
	UPNP_OPEN_HTTP,
	UPNP_SEND_HTTP,
	UPNP_RECV_HTTP,
	UPNP_OPEN_PORTMAP_INFO,
	UPNP_REQ_PORTMAP_INFO,
	UPNP_RECV_PORTMAP_INFO,
	UPNP_OPEN_PORTMAP_DELETE,
	UPNP_REQ_PORTMAP_DELETE,
	UPNP_RECV_PORTMAP_DELETE,
	UPNP_OPEN_PORTMAP_ADD,
	UPNP_REQ_PORTMAP_ADD,
	UPNP_RECV_PORTMAP_ADD,
	UPNP_OPEN_PORTMAP_DEL,
	UPNP_REQ_PORTMAP_DEL,
	UPNP_RECV_PORTMAP_DEL,
	UPNP_NOP
} upnp_state = UPNP_IDLE;

char	upnp_ip_addr_temp[64];
int	upnp_port;
char	upnp_str[64];
char	controlURL[128];
char	upnp_urn[128];
char	post_string[128];

void	send_msearch_gateway(void)
{
	int	ret;

	char    upnp_msg_gateway[] =
		{"M-SEARCH * HTTP/1.1\r\n" \
		"HOST: 239.255.255.250:1900\r\n" \
		"MAN: \"ssdp:discover\"\r\n" \
		"MX: 5\r\n" \
		"ST: urn:schemas-upnp-org:device:InternetGatewayDevice:1\r\n\r\n"
		//"ST: upnp:rootdevice\r\n\r\n"
		};

	ret = sendto(upnp_udp_sd, &upnp_msg_gateway, strlen (upnp_msg_gateway), 0,
                upnp_sock->ai_addr, upnp_sock->ai_addrlen);
	        if (ret < 0)
        {
                time (&cur_time);
                fprintf (log_file, "%24.24s M-SERARCH send error %s\n", ctime(&cur_time), strerror(errno));
                fflush (log_file);
        }
	time (&upnp_send_time);
	if (upnp_debug_sw)
	{
		time(&cur_time);
		fprintf (log_file, "%24.24s M-SEARCH send (gateway)\n",	ctime(&cur_time));
		fprintf (log_file, "%s\n", upnp_msg_gateway);
		fflush (log_file);
	}
}

void	read_upnp_udp(void)
{
	char    *delmi = "\n\r\t\0";
	char	*pnt;
	char	*ip_addr;
	char	*port;
	int	k;

        int     len;
        in_upnp_addr_len = sizeof(struct sockaddr_storage);

        if((len = recvfrom(upnp_udp_sd, &upnp_buf, sizeof(upnp_buf), 0,
                (struct sockaddr *)&in_upnp_addr, &in_upnp_addr_len)) < 0)
        {
                time(&cur_time);
                fprintf (log_file, "%24.24s upnp recvfrom error %s\n",
                        ctime(&cur_time), strerror(errno));
                fflush (log_file);
		FD_CLR (upnp_udp_sd, &read_save);
		close (upnp_udp_sd);
		upnp_udp_sd = 0;
                return;
        }
	if (len == 0) return;

	upnp_buf[len] = 0x00;
	if (upnp_debug_sw)
	{
		fprintf (log_file, "*** upnp read string ***\n");
		fprintf (log_file, "%s\n", upnp_buf);
		fflush (log_file);
	}
	pnt = strtok(upnp_buf, delmi);
	while (pnt)
	{
		for (k = 0 ; k < 9 ; k++)
		{
			*pnt = toupper (*pnt);
			pnt++;
		}
		pnt -= 9;
		if (!memcmp (pnt, "LOCATION:", 9))
		{
			while (memcmp (pnt, "//", 2)) pnt++;
			pnt += 2;
			upnp_port = 0;
			ip_addr = pnt;
			while (*pnt != ':') pnt++;
			*pnt = 0x00;
			memset (upnp_ip_addr, 0x00, sizeof(upnp_ip_addr));
			k = strlen(ip_addr);
			if ((k > 0) && (k < 64))
			{
				memcpy (upnp_ip_addr, ip_addr, k);
				pnt++;
				port = pnt;
				while (*pnt != '/') pnt++;
				*pnt = 0x00;
				upnp_port = atoi(port);
				pnt++;
				memset (upnp_str, 0x00, 64);
				memcpy (upnp_str, pnt, strlen(pnt));
				upnp_state = UPNP_OPEN_HTTP;
				if (k && upnp_port) 
				{
					time (&cur_time);
					fprintf (log_file, "%24.24s router IP address %s\n", ctime(&cur_time), upnp_ip_addr);
					fflush (log_file);
					return;
				}
			}
		}
		pnt = strtok (NULL, delmi);
	}
	time (&cur_time);
	fprintf (log_file, "%24.24s m-search not found Location\n", 
		ctime(&cur_time));
	fflush (log_file);
}

void	upnp (void)
{
	switch (upnp_state)
	{
		case UPNP_IDLE:
			break;

		case UPNP_SEND_MSEARCH_GATEWAY:
			send_msearch_gateway();
			upnp_state = UPNP_RECV_MSEARCH_GATEWAY;
			upnp_msearch_cnt = 0;
			break;

		case UPNP_RECV_MSEARCH_GATEWAY:
			if (FD_ISSET (upnp_udp_sd, &read_set))
			{
				read_upnp_udp();
				upnp_state = UPNP_OPEN_HTTP;
			}
			else
			{
				time (&cur_time);
				if ((cur_time - upnp_send_time) >= 10)
				{
                                	if (upnp_msearch_cnt < 3)
                                	{
						send_msearch_gateway();
                                        	upnp_msearch_cnt++;
					}
					else
					{
						time(&cur_time);
						fprintf (log_file, "%24.24s m-search time out (upnp not support)\n",
							ctime(&cur_time));
						fflush (log_file);
                				FD_CLR (upnp_udp_sd, &read_save);
                				close (upnp_udp_sd);
                				upnp_udp_sd = 0;
						upnp_state = UPNP_NOP;
						upnp_sw = FALSE;
					}
				}
			}
			break;

		case UPNP_OPEN_HTTP:
			FD_CLR (upnp_udp_sd, &read_save);
			if (!open_upnp_http()) break;
			upnp_state = UPNP_SEND_HTTP;
			break;
	
		case UPNP_SEND_HTTP:
			send_upnp_http();
			upnp_state = UPNP_RECV_HTTP;
			time(&upnp_send_time);
			break;

		case UPNP_RECV_HTTP:
                        if (FD_ISSET (upnp_http_sd, &read_set))
                        {
                                read_upnp_http();
				upnp_state =  UPNP_OPEN_PORTMAP_INFO;
                        }
			else
			{
				time (&cur_time);
				if ((cur_time - upnp_send_time) > 5)
				{
					if (upnp_http_sd > 0)
					{
                                		FD_CLR (upnp_http_sd, &read_save);
                                		close (upnp_http_sd);
                                		upnp_http_sd = 0;
					}
					upnp_state = UPNP_IDLE;
				}
			}
			break;
	
		case UPNP_OPEN_PORTMAP_INFO:
			if (!open_upnp_http()) break;
			upnp_state = UPNP_REQ_PORTMAP_INFO;
			break;

		case UPNP_REQ_PORTMAP_INFO:
			send_upnp_port_info();
			upnp_state =  UPNP_RECV_PORTMAP_INFO;
			time(&upnp_send_time);
			break;

        	case UPNP_RECV_PORTMAP_INFO:
			if (FD_ISSET (upnp_http_sd, &read_set))
			{
				read_upnp_info();
			}
			else
			{			
				time (&cur_time);
				if ((cur_time - upnp_send_time) > 5)
				{
                                	if (upnp_http_sd > 0)
					{
						FD_CLR (upnp_http_sd, &read_save);
                                		close (upnp_http_sd);
                                		upnp_http_sd = 0;
					}
					upnp_state = UPNP_IDLE;
				}
			}
			break;

		case UPNP_OPEN_PORTMAP_DELETE:
                        if (!open_upnp_http()) break;
                        upnp_state = UPNP_REQ_PORTMAP_DELETE;
                        time(&upnp_send_time);
			break;

		case UPNP_REQ_PORTMAP_DELETE:
                        send_upnp_port_del();
                        upnp_state =  UPNP_RECV_PORTMAP_DELETE;
                        time(&upnp_send_time);
			break;

		case UPNP_RECV_PORTMAP_DELETE:
                        if (FD_ISSET (upnp_http_sd, &read_set))
                        {
                                read_upnp_port_del();
                                upnp_state = UPNP_OPEN_PORTMAP_ADD;
                        }
                        else
                        {
                                time (&cur_time);
                                if ((cur_time - upnp_send_time) > 5)
                                {
                                        if (upnp_http_sd > 0)
                                        {
                                                FD_CLR (upnp_http_sd, &read_save);
                                                close (upnp_http_sd);
                                                upnp_http_sd = 0;
                                        }
                                        upnp_state = UPNP_IDLE;
                                }
                        }
			break;

		case UPNP_OPEN_PORTMAP_ADD:
			if (!open_upnp_http()) break;
			upnp_state = UPNP_REQ_PORTMAP_ADD;
			break;

                case UPNP_REQ_PORTMAP_ADD:
                        send_upnp_port_add();
                        upnp_state =  UPNP_RECV_PORTMAP_ADD;
                        time(&upnp_send_time);
                        break;

                case UPNP_RECV_PORTMAP_ADD:
			if (FD_ISSET (upnp_http_sd, &read_set))
			{
				read_upnp_port_add();
				upnp_state = UPNP_IDLE;
			}
			else
			{
                        	time (&cur_time);
                        	if ((cur_time - upnp_send_time) > 5)
                        	{
					if (upnp_http_sd > 0)
					{
                                		FD_CLR (upnp_http_sd, &read_save);
                                		close (upnp_http_sd);
                                		upnp_http_sd = 0;
					}
                                	upnp_state = UPNP_IDLE;
				}
			}
			break;

		case UPNP_OPEN_PORTMAP_DEL:
			if (!open_upnp_http()) break;
			upnp_state = UPNP_REQ_PORTMAP_DEL;
			time(&upnp_send_time);
			break;

		case UPNP_REQ_PORTMAP_DEL:
			send_upnp_port_del();
			upnp_state =  UPNP_RECV_PORTMAP_DEL;
			time(&upnp_send_time);
			break;

		case UPNP_RECV_PORTMAP_DEL:
			if (FD_ISSET (upnp_http_sd, &read_set))
			{
				read_upnp_port_del();
				upnp_state = UPNP_IDLE;
			}
			else
			{
				time (&cur_time);
				if ((cur_time - upnp_send_time) > 5)
				{
					if (upnp_http_sd > 0)
					{
						FD_CLR (upnp_http_sd, &read_save);
						close (upnp_http_sd);
						upnp_http_sd = 0;
					}
					upnp_state = UPNP_IDLE;
				}
			}
			break;

		case UPNP_NOP:
			break;
	}
}

int	upnp_status (void)
{
	if (upnp_state == UPNP_IDLE) return TRUE;
	return FALSE;
}

void	upnp_msearch_set (void)
{
	if (upnp_state == UPNP_IDLE)
	{
		FD_SET (upnp_udp_sd, &read_save);	// debug 2020.05.28
		upnp_state = UPNP_SEND_MSEARCH_GATEWAY;
	}
}

void	upnp_portmap_del(void)
{
	if (upnp_state == UPNP_IDLE)
	{
		upnp_state = UPNP_OPEN_PORTMAP_DEL;
	}
}

int	open_upnp_http(void)
{
	struct sockaddr_in server;
	unsigned int **addrptr;
	time_t	atime;
	int	yes = 1;
	if (upnp_ip_addr[0] == 0x00)  return FALSE;
	upnp_http_sd = socket(AF_INET, SOCK_STREAM, 0);
	if (upnp_http_sd < 0) {
		time(&atime);
		fprintf (log_file, "%24.24s socket error upnp_httpd %s\n", 
			ctime(&atime), strerror(errno));
		fflush (log_file);
		upnp_http_sd = 0;
		return FALSE;
	}

	server.sin_family = AF_INET;
	server.sin_port = htons(upnp_port);

	server.sin_addr.s_addr = inet_addr(upnp_ip_addr);
	if (server.sin_addr.s_addr == 0xffffffff) {
		struct hostent *host;

		host = gethostbyname(upnp_ip_addr);
		if (host == NULL) {
			time(&atime);
			if (h_errno == HOST_NOT_FOUND) {
				fprintf(log_file, "%24.24s host not found : %s\n", ctime(&atime), upnp_ip_addr);
			} else {
				fprintf(log_file, "%24.24s %s : %s\n", ctime(&atime), hstrerror(h_errno), upnp_ip_addr);
			}
			fflush (log_file);
			return FALSE;
		}

		addrptr = (unsigned int **)host->h_addr_list;

		while (*addrptr != NULL) {
			server.sin_addr.s_addr = *(*addrptr);

		 	if (connect(upnp_http_sd,
				(struct sockaddr *)&server,
				sizeof(server)) == 0) {
				break;
		 	}

		 	addrptr++;
		}

	 	if (*addrptr == NULL) {
			time(&atime);
			fprintf (log_file, "%24.24s connect error\n", ctime(&atime));
			fflush (log_file);
			return FALSE;
		}
	} else {
		if (connect(upnp_http_sd,
        		(struct sockaddr *)&server, sizeof(server)) != 0) {
			time (&atime);
			fprintf (log_file, "%24.24s connect error\n", ctime(&atime));
			fflush (log_file);
			return FALSE;
		}
	}
	setsockopt (upnp_http_sd, SOL_SOCKET, SO_REUSEADDR, (const char *)&yes, sizeof(yes));	
	FD_SET (upnp_http_sd, &read_save);
	upnp_buf_pnt = 0;
	upnp_add_sw = FALSE;
	return TRUE;
}

void    send_upnp_http(void)
{
	char	buf[256];
	int	ret;

 	memset(buf, 0x00, sizeof(buf));
	sprintf(buf, "GET /%s HTTP/1.1\r\nHost: %s\r\nConnection: Close\r\n\r\n", upnp_str, upnp_ip_addr);
	ret = send(upnp_http_sd, buf, strlen(buf), 0);
	if (upnp_debug_sw)
	{
		fprintf (log_file, "*** send upnp http ***\n");
		fprintf (log_file, "%s\n", buf);
		fflush (log_file);
	}
	if (ret < 0)
	{
		time (&cur_time);
		fprintf (log_file, "%24.24s send upnp http error %s\n", ctime(&cur_time), strerror(errno));
		fflush (log_file);
	}
}

void	send_upnp_port_add(void)
{
	char buf[1024];
	char header[512];
	int	length;
	int	header_l;
	int	ret;

 	memset(buf, 0x00, sizeof(buf));
	memcpy (buf,  "<?xml version=\"1.0\"?>\r\n", 23); 
	length = 23;
	memcpy (&buf[length],  "<s:Envelope xmlns:s:=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n", 126);
	length += 126; 
	memcpy (&buf[length], "<s:Body>\r\n", 10);
	length += 10;
	sprintf (&buf[length], "<m:AddPortMapping xmlns:m=\"%s\">\r\n", upnp_urn);
	length = strlen(buf);
	memcpy (&buf[length],  "<NewRemoteHost></NewRemoteHost>\r\n", 33);
	length += 33;
	sprintf (&buf[length], "<NewExternalPort>%d</NewExternalPort>\r\n", gateway_port);
	length = strlen(buf);
	memcpy (&buf[length],  "<NewProtocol>UDP</NewProtocol>\r\n", 32);
	length += 32;
	sprintf  (&buf[length], "<NewInternalPort>%d</NewInternalPort>\r\n", gateway_port);
	length = strlen(buf);
	sprintf (&buf[length], "<NewInternalClient>%s</NewInternalClient>\r\n", 
		inet_ntoa (OwnMultiIP));
	length = strlen(buf);
	memcpy (&buf[length], "<NewEnabled>1</NewEnabled>\r\n", 28);
	length += 28;
	memcpy (&buf[length], "<NewPortMappingDescription>multi_forward_upnp</NewPortMappingDescription>\r\n", 75);
	length += 75;
	memcpy (&buf[length], "<NewLeaseDuration>0</NewLeaseDuration>\r\n", 40);
	length += 40;
	memcpy (&buf[length], "</m:AddPortMapping>\r\n", 21);
	length += 21;
	memcpy (&buf[length], "</s:Body>\r\n", 11);
	length += 11;
	memcpy (&buf[length], "</s:Envelope>\r\n", 15);
	length += 15;

	memset (header, 0x00, sizeof(header));
	if (strlen(post_string))
	{
        	sprintf(header, "POST %s?%s HTTP/1.1\r\nHost: %s:%d\r\n",
                	controlURL, post_string, upnp_ip_addr, upnp_port);
	}
	else
	{
		sprintf(header, "POST %s HTTP/1.1\r\nHost: %s:%d\r\n",
			controlURL, upnp_ip_addr, upnp_port);
	}

        header_l = strlen(header);;

        sprintf (&header[header_l], "Content-Length: %d\r\nContent-Type: text/xml; charset=\"utf-8\"\r\nConnection: Close\r\n", length);
        header_l = strlen(header);

        sprintf (&header[header_l], "SOAPAction: \"%s#AddPortMapping\"\r\n\r\n", upnp_urn);
        header_l = strlen(header);
	ret = send (upnp_http_sd, header, header_l, 0);
	time (&cur_time);
        if (ret < 0)
        {
                fprintf (log_file, "%24.24s send_upnp_port_add error %s\n", ctime(&cur_time), strerror(errno));
                fflush (log_file);
        }
	ret = send (upnp_http_sd, buf, length, 0);
        if (ret < 0)
        {
                fprintf (log_file, "%24.24s send_upnp_port_add error %s\n", ctime(&cur_time), strerror(errno));
                fflush (log_file);
        }

	if (upnp_debug_sw)
	{
		fprintf (log_file, "*** send upnp string ***\n");
		fprintf (log_file, "%s\n", header);
		fprintf (log_file, "%s\n", buf);
		fflush (log_file);
	}
}

void	send_upnp_port_del(void)
{
	char buf[1024];
	char header[512];
	int	length;
	int	header_l;

 	memset(buf, 0x00, sizeof(buf));
        memcpy (buf,  "<?xml version=\"1.0\"?>\r\n", 23);
        length = 23;
	memcpy (&buf[length],  "<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n", 126);
	length += 126; 
	memcpy (&buf[length], "<s:Body>\r\n", 10);
	length += 10;
	sprintf (&buf[length], "<m:DeletePortMapping xmlns:m=\"%s\">\r\n", upnp_urn);
	length = strlen(buf);
	memcpy (&buf[length], "<NewRemoteHost></NewRemoteHost>\r\n", 33);
	length += 33;
	sprintf (&buf[length], "<NewExternalPort>%d</NewExternalPort>\r\n", gateway_port);
	length = strlen(buf);
	memcpy (&buf[length], "<NewProtocol>UDP</NewProtocol>\r\n", 32);
	length += 32;
	memcpy (&buf[length], "</m:DeletePortMapping>\r\n", 21);
	length += 21;
	memcpy (&buf[length], "</s:Body>\r\n", 11);
	length += 11;
	memcpy (&buf[length], "</s:Envelope>\r\n", 15);
	length += 15;

	memset (header, 0x00, sizeof(header));
	if (strlen(post_string))
	{
        	sprintf(header, "POST %s?%s HTTP/1.1\r\nHost: %s:%d\r\n",
                	controlURL, post_string, upnp_ip_addr, upnp_port);
	}
	else
	{
		sprintf(header, "POST %s HTTP/1.1\r\nHost: %s:%d\r\n",
			controlURL, upnp_ip_addr, upnp_port);
	}
        header_l = strlen(header);;

        sprintf (&header[header_l], "Content-Length: %d\r\nContent-Type: text/xml\r\nConnection: Close\r\n", length);
        header_l = strlen(header);

        sprintf (&header[header_l], "SOAPAction: \"%s#DeletePortMapping\"\r\n\r\n", upnp_urn);
        header_l = strlen(header);
	send (upnp_http_sd, header, header_l, 0);

	send (upnp_http_sd, buf, length, 0);

        if (upnp_debug_sw)
	{
		fprintf (log_file, "*** send upnp string ***\n");
        	fprintf (log_file, "%s\n", header);
        	fprintf (log_file, "%s\n", buf);
       		fflush (log_file);
        }
}

void	send_upnp_port_info(void)
{
	char buf[1024];
	char header[512];
	int	length;
	int	header_l;

 	memset(buf, 0x00, sizeof(buf));
        memcpy (buf,  "<?xml version=\"1.0\"?>\r\n", 23);
        length = 23;
	memcpy (&buf[length],  "<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n", 126);
	length += 126; 
	memcpy (&buf[length], "<s:Body>\r\n", 10);
	length += 10;
	sprintf (&buf[length], "<m:GetSpecificPortMappingEntry xmlns:m=\"%s\">\r\n", upnp_urn);
	length = strlen(buf);
        memcpy (&buf[length],  "<NewRemoteHost></NewRemoteHost>\r\n", 33);
        length += 33;
        sprintf (&buf[length], "<NewExternalPort>%d</NewExternalPort>\r\n", gateway_port);
        length = strlen(buf);
        memcpy (&buf[length],  "<NewProtocol>UDP</NewProtocol>\r\n", 32);
        length += 32;
	memcpy (&buf[length],  "</m:GetSpecificPortMappingEntry>\r\n", 34);
	length += 34;
	memcpy (&buf[length], "</s:Body>\r\n", 11);
	length += 11;
	memcpy (&buf[length], "</s:Envelope>\r\n", 15);
	length += 15;

	memset (header, 0x00, sizeof(header));
	if (strlen(post_string))
	{
        	sprintf(header, "POST %s?%s HTTP/1.1\r\nHost: %s:%d\r\n",
                	controlURL, post_string, upnp_ip_addr, upnp_port);
	}
	else
	{
		sprintf(header, "POST %s HTTP/1.1\r\nHost: %s:%d\r\n",
			controlURL, upnp_ip_addr, upnp_port);
	}

        header_l = strlen(header);

        sprintf (&header[header_l], "Content-Length: %d\r\nContent-Type: text/xml; charset=\"utf-8\"\r\nConnection: Close\r\n", length);
        header_l = strlen(header);

        sprintf (&header[header_l], "SOAPAction: \"%s#GetSpecificPortMappingEntry\"\r\n\r\n", upnp_urn);
        header_l = strlen(header);
	send (upnp_http_sd, header, header_l, 0);

	send (upnp_http_sd, buf, length, 0);

	if (upnp_debug_sw)
	{
		fprintf (log_file, "*** send_upnp_port_info ***\n");
		fprintf (log_file, "%s\n", header);
		fprintf (log_file, "%s\n", buf);
		fflush (log_file);
	}
}

int	http_read (void)
{
	int	len;

	len = 0;
        upnp_buf_pnt = read(upnp_http_sd,
                upnp_buf, sizeof(upnp_buf));
        if (upnp_buf_pnt >  0)
        {
        	while (upnp_buf_pnt > 0)
        	{
                	len += upnp_buf_pnt;
                	upnp_buf_pnt = read (upnp_http_sd,
                        	&upnp_buf[len], sizeof (upnp_buf));
		}
	}
	upnp_buf[len] = 0x00;
	FD_CLR (upnp_http_sd, &read_save);
	close (upnp_http_sd);
	upnp_http_sd = 0;
	return len;
}


void	read_upnp_http(void)
{
	int	k;
	int	kk;
	int	kkk;
	int	len;
	int	sw;
	int	urn_sw;
	time_t	atime;
        char    *pnt;
        char    *ip_addr;
        char    *port;
	char	*post;

	if ((len = http_read()) == 0) return;
	sw = FALSE;
	urn_sw = FALSE;
	if (upnp_debug_sw)
	{
		fprintf (log_file, "*** read upnp http ***\n");
		fprintf (log_file, "%s\n", upnp_buf);
		fflush (log_file);
	}
	memset (post_string, 0x00, sizeof(post_string));
	post = NULL;
	for (k = 0 ; k < len ; k++) 
	{
		if (!memcmp (&upnp_buf[k], 
			"urn:schemas-upnp-org:service:WANPPPConnection:1", 47))  
		{
			sw = TRUE;
			time(&atime);
			memset (upnp_urn, 0x00, sizeof(upnp_urn));
			memcpy (upnp_urn, &upnp_buf[k], 47);
			if (upnp_debug_sw)
			{
				fprintf (log_file, "%24.24s %s\n", ctime(&atime), upnp_urn);
				fflush (log_file);
			}
			urn_sw = TRUE;
		}
		else if (!memcmp (&upnp_buf[k], 
			"urn:schemas-upnp-org:service:WANIPConnection:1", 46))
		{
			sw = TRUE;
			time(&atime);
			memset (upnp_urn, 0x00, sizeof(upnp_urn));
			memcpy (upnp_urn, &upnp_buf[k], 46);
			if (upnp_debug_sw)
			{
				fprintf (log_file, "%24.24s %s\n", ctime(&atime), upnp_urn);
				fflush (log_file);
			}
			urn_sw = TRUE;
		}
		else if (!memcmp (&upnp_buf[k], "<URLBase>", 9))
		{
			for (kk = k + 16 ; kk < len ; kk++)
			{
				if (upnp_buf[kk] == ':')
				{
					upnp_buf[kk] = 0x00;
					break;
				}
			}
			memset (upnp_ip_addr, 0x00, sizeof(upnp_ip_addr));
			memcpy (upnp_ip_addr, &upnp_buf[k+16], strlen (&upnp_buf[k+16]));
			for (kkk = kk + 1; kkk < len ; kkk++)
			{
				if ((upnp_buf[kkk] == '/') || (upnp_buf[kkk] == '<'))
				{
					upnp_buf[kkk] = 0x00;
					break;
				}
			} 
			upnp_port = atoi(&upnp_buf[kk+1]);
			if (upnp_debug_sw)
			{
				time (&atime);
				fprintf (log_file, "%24.24s URLBase %s:%d\n", 
					ctime(&atime), upnp_ip_addr, upnp_port);
				fflush (log_file);
			}
		}

		if (sw)
		{
			if (!memcmp (&upnp_buf[k], "<controlURL>", 12))
			{
                                if (upnp_debug_sw)
				{
					time (&atime);
                                	fprintf (log_file, "%24.24s %s\n", ctime(&atime), controlURL);
                                	fflush (log_file);
                                }
				ip_addr = NULL;
				port = NULL;
				pnt = &upnp_buf[k+12];
				post = NULL;
				for (kk = k + 12 ; kk < len ; kk++)
				{
					if (!memcmp (&upnp_buf[kk], "http://", 7))
					{
						ip_addr = &upnp_buf[kk+7];
						kk += 6;
					}
					if (ip_addr)
					{
						if (upnp_buf[kk] == ':')
						{
							upnp_buf[kk] = 0x00;
							port = &upnp_buf[kk+1];
						}
						if (port && upnp_buf[kk] == '/')
						{
							upnp_buf[kk] = 0x00;
							memset (upnp_ip_addr, 0x00, sizeof(upnp_ip_addr));
                                			memcpy (upnp_ip_addr, ip_addr, strlen(ip_addr));
                                			upnp_port = atoi(port);
							ip_addr = NULL;
							pnt = &upnp_buf[kk];
						}
					}
					else
					{
						if (upnp_buf[kk] == '?')
						{
							post = &upnp_buf[kk+1];
							upnp_buf[kk] = 0x00;
						}
						else if (upnp_buf[kk] == '<')
						{
							upnp_buf[kk] = 0x00;
							break;
						}
					}
				}
				sw = FALSE;
				time(&atime);
				*pnt = '/';
				kk = strlen(pnt);
				memset (controlURL, 0x00, sizeof(controlURL));
				memcpy (controlURL, pnt, kk);
				//memcpy (&controlURL[kk], "/WANPPPConn1", 12);
				if (post)
				{
					memset (post_string, 0x00, sizeof(post_string));
					memcpy (post_string, post, strlen(post));
				}
				//URL_sw = TRUE;
				//if (upnp_debug_sw)
				{
					fprintf (log_file, "%24.24s %s ip:%s port:%d post param:%s\n", ctime(&atime), controlURL, upnp_ip_addr, upnp_port, post_string);
					fflush (log_file);
				}
			}
		}
	}

	if (urn_sw)
	{
		upnp_state = UPNP_OPEN_PORTMAP_INFO;
	}
	else
	{
		upnp_state = UPNP_IDLE;
	}
}

void	read_upnp_info(void)
{
	int	k;
	int	len;

	if ((len = http_read()) == 0) return;
	if (upnp_debug_sw)
	{
		fprintf (log_file, "*** read upnp port info ***\n");
		fprintf (log_file, "%s\n", upnp_buf);
		fflush (log_file);
	}
	for (k = 0 ; k < len ; k++) 
	{
		if (!memcmp (&upnp_buf[k], "HTTP/1.1 500", 12)
			|| !memcmp (&upnp_buf[k], "HTTP/1.0 500", 12))
		{
			upnp_state = UPNP_OPEN_PORTMAP_ADD;;
			return;
		}
#if 0
		else if (!memcmp (&upnp_buf[k], "HTTP/1.1 302", 12)
			|| !memcmp (&upnp_buf[k], "HTTP/1.0 302", 12))
		{
                	FD_CLR (upnp_udp_sd, &read_save);
                        close (upnp_udp_sd);
                        upnp_udp_sd = 0;
                        upnp_state = UPNP_NOP;
			return;
		}
#endif
	}
	upnp_state = UPNP_OPEN_PORTMAP_DELETE;
	return;
}

void	read_upnp_port_add(void)
{
	int	len;
	int 	k;

	if ((len = http_read()) == 0) return;

	if (upnp_debug_sw)
	{
		fprintf (log_file, "*** read upnp port add ***\n");
		fprintf (log_file, "%s\n", upnp_buf);
		fflush (log_file);
	}

        for (k = 0 ; k < len ; k++)
        {
                if (!memcmp (&upnp_buf[k], "HTTP/1.1 500", 12)
                        || !memcmp (&upnp_buf[k], "HTTP/1.0 500", 12))
                {
                        upnp_state = UPNP_IDLE;
			upnp_sw = FALSE;
                        return;
                }
        }
}

void    read_upnp_port_del(void)
{
        int     len;

        if ((len = http_read()) == 0) return;

        if (upnp_debug_sw)
	{
        	fprintf (log_file, "*** read upnp port del ***\n");
        	fprintf (log_file, "%s\n", upnp_buf);
        	fflush (log_file);
        }
}

int	upnp_portmap_del_wait(void)
{
	upnp ();
	if (upnp_state == UPNP_IDLE) return TRUE;
	return FALSE;
}

