#include	"multi_forward.h"

void	read_dsgwd_conf(void)
{
	char	buff[256];
	char	*delmi = " =\n\r\t\0";
	char	*pnt;
	char	*p;
	int	n;
	int	len;
	time_t	atime;

	FILE	*config_file;
	
	config_file = fopen (DSGWD_CONF_FILE, "r");
	if (!config_file)
	{
		time(&atime);
		fprintf (log_file, "%24.24s dsgwd config file not found (%s)\n", ctime(&atime), DSGWD_CONF_FILE);
		fflush (log_file);
		return;
	}

	while (fgets (buff, 255, config_file))
	{
		if (buff[0] != '#')
		{
			n = 0;
			while (buff[n] == 0x20) n++;
			p = strtok(&buff[n], delmi);
			if (p != NULL)
			{
				pnt = strtok(NULL, delmi);
	
				if (!memcmp (p, "GW_ETHIFNAME", 12))
				{
					memset (NicDevice, 0x00, IFNAMSIZ);
					len = strlen (pnt);
					if (len > IFNAMSIZ) len = IFNAMSIZ;
					memcpy (NicDevice, pnt, len);
				}
                                if (!memcmp (p, "ZR_CALLSIGN", 11))
                                {
                                        memset (zr_callsign, 0x20, 8);
                                        len = strlen(pnt);
                                        if (len > 7) len = 7;
                                        memcpy (zr_callsign, pnt, len);
                                        zr_callsign[7] = 'G';
                                }
                                else if (!memcmp (p, "MGSV_ADDR", 9))
                                {
                                        memset (trust_server, 0x00, sizeof(trust_server));
                                        memcpy (trust_server, pnt, strlen(pnt));
                                }
                                else if (!memcmp (p, "MGSV_PORT", 9))
                                {
                                        trust_port = atoi (pnt);
                                }
			}
		}
	}

	fclose (config_file);
}

