#include	"multi_forward.h"
#include	"config.h"

void	pselectSet(void);
int	portSet(void);
void    lost_frame(void);
int     read_config(int argc, char **argv);
int     handler_init(void);
void	ctbl_send(void);
int	getOwnIp(void);
void	read_dsgwd_conf(void);
void	multi_connect (void);
int	forward_init(void);
void	send_hole_punch (struct area_callsign *ar_call_next);
int	forward_resend (void);
void	httpd_srv_accept(void);
void	multi_read(struct MultiConnectTable *nextTable);
void	read_upnp_udp(void);
void    read_upnp_http(void);
void	httpd_srv_recv(int sock);
void	repeater_name_req (void);
void	trust_resp_check(void);
void	keep_alive_check (void);
void    status_check (void);
void	upnp_msearch_set (void);
void	upnp(void);
void	send_disconnect_hole_punch (void);
void	upnp_portmap_del(void);
int	read_md5(void);
int	upnp_portmap_del_wait(void);
int	upnp_status (void);
void    connected_table_send (void);
void    hole_punch_server_set (void);

extern	void	handler(int sig);

time_t			start_time;
struct	timeval		time_100ms;

int main(int argc, char** argv)
{

	int	i;
	int	ret;
	struct	MultiConnectTable	*next;
	struct  area_callsign     *ar_call_next;

	time_t	atime;
	time_t	uptime;
	tzset();

        uname(&uname_buf);

	hole_punch_port = HOLE_PUNCHD_PORT;
	memset (hole_punch_server, 0x00, 128);
	memcpy (hole_punch_server, HOLE_PUNCHD_SERVER, sizeof(HOLE_PUNCHD_SERVER));

	log_file = fopen (LOG_FILE, "a");
	if (log_file == NULL)
	{
		return 1;
	}
	time (&start_time);
	srand (start_time);

	fprintf (log_file, "%24.24s D-STAR X-change (xchange) add on multi_forward V%5.5s (%s  %s) Start\n", 
						ctime(&start_time), PACKAGE_VERSION, __DATE__, __TIME__);
	fflush (log_file);

	pid_file = fopen(PID_FILE, "r");
	if (pid_file == NULL)
	{
		pid_file = fopen(PID_FILE, "w");
	}
	else
	{
		fprintf (log_file, "%24.24s Already running status.\n", 
			ctime(&atime));
		fclose (log_file);
		return -1;
	}
	fprintf (pid_file, "%d", getpid());
	fclose (pid_file); 
	if (read_md5()) return -1;
	/* default value */
	fwd_port = 0;
	sig_term = FALSE;
	debug_sw = FALSE;
	upnp_debug_sw = FALSE;
	restart_sw = FALSE;
	MultiConnectTablePnt = NULL;
	ar_callsign_pnt = NULL;
	http_port = 0;

	fwd_sd = 0;

	area_call_set_time = 0;
	status_pnt = NULL;
	status_send_time = 0;

	gateway_port = GATEWAY_PORT;

	memset (trust_server, 0x00, sizeof(trust_server));
	memcpy (trust_server, TRUST_SERVER, sizeof(TRUST_SERVER));

	if (!handler_init()) goto end;

	time (&atime);

	upnp_sw = TRUE;
	memset (forward_addr, 0x00, sizeof(forward_addr));
	if (!read_config (argc, (char **)argv)) goto end;
        if (debug_sw) 
	{
		fprintf (log_file, "                         %s %s %s\n",
                	uname_buf.sysname, uname_buf.release, uname_buf.version);
		fprintf (log_file, "%24.24s Word Size : %d\n", ctime(&atime), __WORDSIZE);
		fflush (log_file);
	}
	upnp_http_sd = 0;
	upnp_udp_sd = 0;
	trust_port = TRUST_PORT;
	memset (NicDevice, 0x00, IFNAMSIZ);
	memcpy (NicDevice, "eth0", 4);
	read_dsgwd_conf();
	pselectSet();	// FD & sig init
	if (!forward_init()) goto end;
	if (!portSet()) goto end;
	if (!getOwnIp()) goto end;

	server_table_pnt = NULL;
	hole_punch_server_set ();
	hpch_reply_port = 0;
	ar_call_next = ar_callsign_pnt;
	while (ar_call_next)
	{
		send_hole_punch(ar_call_next);
		ar_call_next = ar_call_next->next;
	}
	hole_punch_interval = 10;
	hole_punch_port_save = multi_port;

	memset (dcs_name, 0x20, 8);
	//read_dcs_config();

        ctblRp = malloc (sizeof (struct ctblPkt));
        ctblWp = ctblRp;
        ctblRp->next = NULL;

	time_100ms.tv_sec = 0;
	time_100ms.tv_usec = 100000;

	memset (forward_buff_save, 0x00, sizeof(forward_buff_save));
	multi_send_seq = 0;
	fwd_send_seq = 0;

	memset (current_use_call, 0x20, 8);

	upnp_msearch_cnt = 0;
	upnp_send_time = 0;

	hole_punch_send_cnt = 0;

	while (1)
	{
		memcpy (&read_set, &read_save, sizeof(read_save));
		memcpy (&sigset, &save_sig, sizeof(save_sig));
		ret = pselect (FD_SETSIZE, &read_set, (fd_set *)NULL, 
				(fd_set *)NULL, &timeout, &sigset);
		time (&atime);
		if (ret < 0) 
		{
                	fprintf (log_file, "%24.24s pselect error %s\n", 
				ctime(&atime), strerror(errno));
                	fflush (log_file);
			break;
		}
		else if (ret > 0)
		{
                	if (FD_ISSET (fwd_sd, &read_set))
                	{
                        	if (!forward_resend()) goto end;
                	}
			if (FD_ISSET (multi_sd, &read_set))
			{
				multi_connect();
			}
			if (FD_ISSET (http_sd, &read_set))
			{
				httpd_srv_accept();
			}
			if (http_port)
			{
				for (i = 1 ; i < FD_SETSIZE ; i++)
				{
					if ((i == fwd_sd)
						|| (i == multi_sd)
						|| (i == upnp_udp_sd)
						|| (i == http_sd)) goto skip;
					if ((upnp_http_sd > 0) && (i == upnp_http_sd)) goto skip;
					if (FD_ISSET (i, &read_set)) httpd_srv_recv(i);
					skip: continue;
				}
			}
		}
                ar_call_next = ar_callsign_pnt;
                while (ar_call_next)
                {
			if (!ar_call_next->hole_punch_ack_sw)
			{
				time (&atime);
				if ((atime - ar_call_next->hole_punch_send_time) >= 2)  
				{	
					ar_call_next->hole_punch_send_cnt++;
					if (ar_call_next->hole_punch_send_cnt < 50)
					{
						send_hole_punch(ar_call_next);
					}
					else 
					{
						fprintf (log_file, "%24.24s hole punch ack not receive\n", ctime(&atime));
						ar_call_next->hole_punch_send_cnt = 0;
						if (restart_sw)
						{
							sleep (60);
						}
						//goto end;
					}
				}
			}
			ar_call_next = ar_call_next->next;
		}
		ctbl_send();
		next = MultiConnectTablePnt;
		while (next)
		{
			multi_read(next);
			next = next->f_chain;
		}
		time(&atime);
		if ((atime - area_call_set_time) >= 300)
		{
			repeater_name_req();
			time (&area_call_set_time);
		}
		if ((atime - status_send_time) >= 180)
		{
			connected_table_send ();
		}
		if ((atime - server_table_load_time) >= 3600)
		{
			reload_hole_punch_server_set();
		}
		trust_resp_check();
		ar_call_next = ar_callsign_pnt;
		while (ar_call_next)
		{
			if ((atime - ar_call_next->hole_punch_send_time) >= hole_punch_interval)
			{
				send_hole_punch(ar_call_next);
			}
			ar_call_next = ar_call_next->next;
		}
		keep_alive_check();
		status_check();
		if (upnp_sw)
		{
			if ((atime - upnp_send_time) > 600) upnp_msearch_set();
			upnp();
			
		}
		if (sig_term) break;
	}

	// socket close
end:
	time(&atime);
	uptime = atime - start_time;
	fprintf (log_file, "%24.24s D-STAR X-change (xchange) add on multi forward_terminated (Up : %ldd%2ldh%2ldm%2lds)\n\n",
			ctime(&atime), 
			(uptime / 86400),
			((uptime % 86400) / 3600),
			(((uptime % 86400) % 3600) / 60),
			(((uptime % 86400) % 3600) % 60));
	remove (PID_FILE);
	send_disconnect_hole_punch();
	close (multi_sd);
	if ((upnp_udp_sd > 0) && upnp_status())
	{
		FD_ZERO (&read_save);
		upnp_portmap_del();
		FD_SET (upnp_udp_sd, &read_save);
		while (1)
		{
                	memcpy (&read_set, &read_save, sizeof(read_save));
                	memcpy (&sigset, &save_sig, sizeof(save_sig));
                	ret = pselect (FD_SETSIZE, &read_set, (fd_set *)NULL,
                                (fd_set *)NULL, &timeout, &sigset);
			if (upnp_portmap_del_wait()) break;
		}			
		close (upnp_udp_sd);
	}

	fclose (log_file);
    	return 0;
}

