#include	"multi_forward.h"

void    status_init (struct status *sta, char FullName[], int port);

int	read_config(int argc, char **argv)
{
	char	buff[256];
	char	*delmi = " =\n\r\t\0";
	char	*pnt;
	char	*p;
	int	n;
	time_t	atime;
	int	false_ret;
	int	field_sw;
	int	port;
	char    fqdn[128];
	struct  status	*status_next;

	FILE	*config_file;
	
	if (argc == 2)
	{
		config_file = fopen (argv[1], "r");
		if (!config_file)
		{
			time(&atime);
			fprintf (log_file, "%24.24s config file not found (%s)\n", ctime(&atime), argv[1]);
			fflush (log_file);
			return FALSE;
		}
	} 
	else
	{
		config_file = fopen (CONFIG_FILE,"r");
		if (!config_file)
		{
			time(&atime);
			fprintf (log_file, "%24.24s config file not found (%s)\n", 
						ctime(&atime), CONFIG_FILE);
			fflush (log_file);
			return FALSE;
		}
	}

	while (fgets (buff, 255, config_file))
	{
		if (buff[0] != '#')
		{
			n = 0;
			while (buff[n] == 0x20) n++;
			p = strtok(&buff[n], delmi);
			if (p != NULL)
			{
				pnt = strtok(NULL, delmi);
	
				if (!memcmp (p, "FORWARD_PORT", 12))
				{
					fwd_port = atoi (pnt);
				}
				else if (!memcmp (p, "FORWARD_ADDR", 12))
				{
					memset (forward_addr, 0x00, sizeof(forward_addr));
					memcpy (forward_addr, pnt, strlen(pnt));
				}
				else if (!memcmp (p, "MULTI_CONNECT_PORT", 18))
				{
					multi_port = atoi (pnt);
				}
				else if (!memcmp (p, "HOLE_PUNCH_SERVER", 17))
				{
					memset (hole_punch_server, 0x00, sizeof(hole_punch_server));
					memcpy (hole_punch_server, pnt, strlen(pnt));
				}
				else if (!memcmp (p, "DEBUG", 5))
				{
					debug_sw = atoi(pnt);
				}
				else if (!memcmp (p, "UPNP_DEBUG", 10))
				{
					upnp_debug_sw = atoi(pnt);
				}
				else if (!memcmp (p, "UPNP_SW", 7))
				{
					upnp_sw = atoi (pnt);
				}
				else if (!memcmp (p, "HTTP_PORT", 9))
				{
					http_port = atoi (pnt);
				}
                                else if (!memcmp (p, "STATUS", 7))
                                {
                                        n = 0;
                                        field_sw = 0;
                                        port = 0;
                                        memset (fqdn, 0x20, 128);
                                        while (*pnt)
                                        {
                                                if (*pnt != ',')
                                                {
                                                        if (field_sw)
                                                        {
                                                                if (isdigit (*pnt)) port = port * 10 + *pnt - '0';
                                                        }
                                                        else
                                                        {
                                                                if (*pnt == ':') field_sw = 1;
                                                                else
                                                                {
                                                                        if (*pnt != 0x20) fqdn[n++] = *pnt;
                                                                        if (n > 127) n = 127;
                                                                }
                                                        }
                                                }
                                                else
                                                {
                                                        status_next = malloc (sizeof (struct status));
                                                        if (status_next != NULL)
                                                        {
                                                                fqdn[n] = 0x00;
                                                                status_init(status_next, fqdn, port);
								status_next->f_chain = status_pnt;
								status_pnt = status_next;
                                                                port = 0;
                                                                n = 0;
                                                                field_sw = 0;
                                                        }
                                                        else
                                                        {
                                                                time(&atime);
                                                                fprintf (log_file, "%24.24s Memoty not allocate (STATUS)\n",
										ctime(&atime));
                                                                fflush (log_file);
                                                        }
                                                }
                                                pnt++;
                                        }
                                        if (n)
                                        {
                                                fqdn[n] = 0x00;
                                                status_next = malloc (sizeof (struct status));
                                                status_init(status_next, fqdn, port);
						status_next->f_chain = status_pnt;
						status_pnt = status_next;
                                        }
                                }
				else
				{
					time (&atime);
					fprintf (log_file, "%24.24s Error on config file : %s\n",ctime(&atime), buff);
					fflush (log_file);
				}
			}
		}
	}

	fclose (config_file);

	false_ret = FALSE;
	time (&atime);
	if (fwd_port <= 0)
	{
		fprintf (log_file, "%24.24s Forward  port not assign.\n", ctime(&atime));
		false_ret = TRUE;
		fflush (log_file);
	}

	if (false_ret) return FALSE;
	return TRUE;
	
}

void    status_init (struct status *sta, char FullName[], int port)
{
        sta->f_chain = NULL;
        sta->port = port;
        memcpy (sta->fqdn, FullName, 128);
}

