#!/usr/bin/env ruby -Ku

FLV_HEADER_SIZE = 9
FLV_TAG_SIZE = 15
FLV_HEADER = Struct.new( :signature, :version, :flags, :offset )
FLV_TAG = Struct.new( :previousTagSize, :type, :bodyLength, :timestamp, :timestampExtended, :streamId )
LastPreviousTagSize = 4

def flv2mp3( flv_path, mp3_path )
	result = false

	begin
		port = open( flv_path, "rb" )	# binary mode for Windows
		begin
			flv = port.read
		ensure
			port.close
		end

		header = FLV_HEADER.new( flv[0,3], flv[3], flv[4], flv[5, 4] )
		raise "No flv header found." if flv.length < FLV_HEADER_SIZE
		raise "Missing flv signature." unless header.signature == "FLV"
		raise "Missing audio data." if (header.flags & 4) == 0
		raise "Unsupported flv format." unless header.offset == "\x00\x00\x00#{FLV_HEADER_SIZE.chr}"

		read_size = FLV_HEADER_SIZE
		open( mp3_path, "wb" ) { |mp3|	# binary mode for Windows
			while true
				remaining = flv.length - read_size
				break if remaining == LastPreviousTagSize
				raise "Flv is insufficient in length." if remaining < FLV_TAG_SIZE
				tag = FLV_TAG.new( flv[read_size, 4], flv[read_size + 4], flv[read_size + 5, 3], flv[read_size + 8, 3], flv[read_size + 11], flv[read_size + 12, 3] )
				read_size += FLV_TAG_SIZE
				body_length = (tag.bodyLength[0] << 16) + (tag.bodyLength[1] << 8) + tag.bodyLength[2];
				raise "Flv is insufficient in length." if remaining < body_length
				if tag.type == 8
					raise "Audio data is not mp3." if (flv[read_size] & 0x00f0) != 0x20
					raise "Failed to write mp3 file." if mp3.write( flv[read_size + 1, body_length - 1] ) != body_length - 1
				end
				read_size += body_length
			end
		}
		result = true
	rescue
		puts( $!.to_s )
		File.delete( mp3_path ) if File.exist?( mp3_path )
	end

	return result
end

#flv2mp3( "foo.flv", "foo.mp3" )
