/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package android.i18n;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import org.apache.commons.jxpath.JXPathContext;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

/**
 *
 * @author nobuo
 */
public class XMLdom4j {

    JTable table;
    String cDir = "xmldata\\project\\res\\values";

    private final static String PLURALS = "plurals";
    private final static String ITEMS = "item";

    public XMLdom4j(JTable table) {
        this.table = table;
    }

    /**
     * XMLファイルの読み込み
     *
     * @param file
     */
    public void read(File file) {
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(file);
            Element element = document.getRootElement();

            //System.out.println(element.asXML());
            JXPathContext context = JXPathContext.newContext(element);
            System.out.println("dom4J");
            // attributes メソッド
            List list = element.attributes();
            for (int i = 0; i < list.size(); i++) {
                Attribute attribute = (Attribute) list.get(i);
                // 属性名を出力
                System.out.println(attribute.getName());
            }

            // attributeIterator メソッド
            for (Iterator iter = element.attributeIterator(); iter.hasNext();) {
                Attribute attribute = (Attribute) iter.next();
                // 属性値を出力
                System.out.println(attribute.getText());
            }
            treeWalk(element);
            //String pls = (String) context.getValue("//resources/plurals/item[@quantity=\"one\"]");
            //System.out.println(" : " + pls);
            // "zero" | "one" | "two" | "few" | "many" | "other"  
//            List nodes = document.selectNodes("/resources/plurals/item[@quantity=one]");
//            
//            for(Iterator iter = nodes.iterator(); iter.hasNext();) {
//                Node node = (Node) iter.next();
//                System.out.println("Tag : " + node.getText());
//            }
            //for(Iterator i = root.elementIterator(); i.hasNext();){
            //    Element element = (Element) i.next();
            // Tag System.out.println("FirstTag : " + element.getName());
            // 値　System.out.println("Title : " + element.getStringValue());
            // name System.out.println("name : " + element.attributeValue("name"));
            //}
        } catch (DocumentException ex) {
            Logger.getLogger(XMLdom4j.class.getName()).log(Level.SEVERE, null, ex);
        }

    }

    public void treeWalk(Element element) {
        int size = element.nodeCount();
        for (int i = 0; i < size; i++) {
            Node node = element.node(i);
            if (node instanceof Element) {
                System.out.println("name : " + node.getName());
                System.out.println("value : " + node.getStringValue());
                treeWalk((Element) node);
            } else {

            }

        }
    }

    public void WriteXml() {
        try {
            // Documentオブジェクト生成
            org.dom4j.Document document = DocumentHelper.createDocument();

            // ルートエレメント生成
            Element root = document.addElement("resources");

            // stringエレメント追加
            Element element = root.addElement("string");
            Element attribute = element.addAttribute("name", "hello");
            attribute.addText("こんにちわ");
            // titleエレメント追加
            //Element title = attribute.addElement("title");
            //title.addText("Book1");

            // authorエレメント追加
            //Element author = attribute.addElement("author");
            //author.addText("Author1");
            // priceエレメント追加
            //Element price = attribute.addElement("price");
            //price.addText("1000");
            OutputFormat pFormat = OutputFormat.createPrettyPrint();

            //OutputFormat myFormat = new OutputFormat("", true, "UTF-8");
            pFormat.setNewLineAfterDeclaration(false);
            //pFormat.setNewlines(true);
            //myFormat.setNewLineAfterNTags(2);
            //pFormat.setIndent(true);
            //pFormat.setIndentSize(2);
            XMLWriter writer;
            writer = new XMLWriter(new FileWriter("dom4j_01.xml"), pFormat);

            writer.setIndentLevel(2);
            writer.write(document);
            writer.flush();
            writer.close();

        } catch (IOException ex) {
            Logger.getLogger(XMLdom4j.class.getName()).log(Level.SEVERE, null, ex);
        }

    }

}
