/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package android.i18n;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

/**
 *
 * @author nobuo
 */
public class StringsXSDCheck {

    public StringsXSDCheck(String file) {
        try {
            // 1. Lookup a factory for the W3C XML Schema language
            SchemaFactory factory
                    = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            // 2. Compile the schema.
            // Here the schema is loaded from a java.io.File, but you could use 
            // a java.net.URL or a javax.xml.transform.Source instead.
            File schemaLocation = new File("xmldata/strings.xsd");
            Schema schema = factory.newSchema(schemaLocation);
            
            // 3. Get a validator from the schema.
            Validator validator = schema.newValidator();
            
            // 4. Parse the document you want to check.
            Source source = new StreamSource(file);

            // 5. Check the document
            try {
                validator.validate(source);
                System.out.println(file + " is valid.");
            } catch (SAXException ex) {
                System.out.println(file + " is not valid because ");
                System.out.println(ex.getMessage());
            }
        } catch (SAXException | IOException ex ) {
            Logger.getLogger(StringsXSDCheck.class.getName()).log(Level.SEVERE, null, ex);
        }

    }
}
