/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package android.i18n;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;

/**
 *
 * @author nobuo
 */
public class MenuBuilder {
    JTable table;
    DefaultTableModel model;
    JMenuBar menubar;
    JMenu mnuFile;
    JMenu mnuEdit;
    JMenu mnuTool;
    JMenu mnuHelp;

    /**
     * コンストラクタ
     *
     * @param table
     * @param model
     */
    public MenuBuilder(JTable table, DefaultTableModel model) {
        this.table = table;
        this.model = model;
        menubar = new JMenuBar();
        createMainItem();
        setKeyboardNemonic();
        setMainItem1();
        setMainItem2();
        setMainItem3();
        setMainItem4();
        setMainItem();
    }

    public JMenuBar getMenuBar() {
        // メニューを返す
        return menubar;
    }

    private void setMainItem1() {
        // File
        ImageIcon imgNew = new ImageIcon("./image/ic_New01.png");
        ImageIcon imgOpen = new ImageIcon("./image/ic_OpenFile01.png");
        ImageIcon imgSave = new ImageIcon("./image/ic_Save01.png");
        ImageIcon imgSaveAs = new ImageIcon("./image/ic_SaveAs01.png");
        ImageIcon imgProperty = new ImageIcon("./image/ic_Property01.png");
        ImageIcon imgQuit = new ImageIcon("./image/ic_Quit01.png");

        JMenuItem menuNew = new JMenuItem("New", imgNew);
        JMenuItem menuOpen = new JMenuItem("Open", imgOpen);
        JMenuItem menuSave = new JMenuItem("Save", imgSave);
        JMenuItem menuSaveAs = new JMenuItem("SaveAs", imgSaveAs);
        JMenuItem menuProperty = new JMenuItem("Property", imgProperty);
        JMenuItem menuQuit = new JMenuItem("Quit", imgQuit);

        menuSave.setMnemonic(KeyEvent.VK_S);
        menuSave.setAccelerator(
                KeyStroke.getKeyStroke(KeyEvent.VK_S, InputEvent.CTRL_DOWN_MASK));
        mnuFile.add(menuNew);
        mnuFile.add(menuOpen);
        mnuFile.add(menuSave);
        mnuFile.add(menuSaveAs);
        mnuFile.addSeparator();
        mnuFile.add(menuProperty);
        mnuFile.add(menuQuit);
        
        FileActionListener fa = new FileActionListener(table);
        menuNew.addActionListener(fa.new FileNew());
        menuOpen.addActionListener(fa.new FileOpen());
        menuSave.addActionListener(fa.new FileSave());
        menuSaveAs.addActionListener(fa.new FileSaveAs());
        menuProperty.addActionListener(fa.new FileProperty());
        menuQuit.addActionListener(fa.new FileQuit());
       
    }

    private void setMainItem2() {
        // Edit
        ImageIcon imgUndo = new ImageIcon("./image/ic_Undo01.png");
        ImageIcon imgRedo = new ImageIcon("./image/ic_Redo01.png");
        ImageIcon imgCut = new ImageIcon("./image/ic_Cut01.png");
        ImageIcon imgCopy = new ImageIcon("./image/ic_Copy01.png");
        ImageIcon imgPaste = new ImageIcon("./image/ic_Paste01.png");
        ImageIcon imgAddRow = new ImageIcon("./image/ic_AddRow01.png");

        JMenuItem menuUndo = new JMenuItem("Undo", imgUndo);
        JMenuItem menuRedo = new JMenuItem("Redo", imgRedo);
        JMenuItem menuCut = new JMenuItem("Cut", imgCut);
        JMenuItem menuCopy = new JMenuItem("Copy", imgCopy);
        JMenuItem menuPaste = new JMenuItem("Paste", imgPaste);
        JMenuItem menuAddRow = new JMenuItem("AddRow", imgAddRow);
        mnuEdit.add(menuUndo);
        mnuEdit.add(menuRedo);
        mnuEdit.addSeparator();
        mnuEdit.add(menuCut);
        mnuEdit.add(menuCopy);
        mnuEdit.add(menuPaste);
        mnuEdit.addSeparator();
        mnuEdit.add(menuAddRow);
        menuUndo.setEnabled(false);
        menuRedo.setEnabled(false);
        
        EditActionListener ea = new EditActionListener(table, model);
        menuCut.addActionListener(ea.new EditCut());
        menuCopy.addActionListener(ea.new EditCopy());
        menuPaste.addActionListener(ea.new EditPaste());
        menuAddRow.addActionListener(ea.new EditAddRow());
    }

    private void setMainItem3() {
        // Tool
        ImageIcon imgSortA = new ImageIcon("./image/ic_Sort_A01.png");
        ImageIcon imgSortD = new ImageIcon("./image/ic_Sort_D01.png");
        JMenuItem menuSortA = new JMenuItem("Sort-A", imgSortA);
        JMenuItem menuSortD = new JMenuItem("Sort-D", imgSortD);
        mnuTool.add(menuSortA);
        mnuTool.add(menuSortD);

    }

    private void setMainItem4() {
        // Help
        ImageIcon imgHelp = new ImageIcon("./image/ic_Help01.png");
        ImageIcon imgVerInfo = new ImageIcon("./image/ic_Info01.png");
        JMenuItem menuHelp = new JMenuItem("Help", imgHelp);
        JMenuItem menuVerInfo = new JMenuItem("Version Info", imgVerInfo);
        JMenuItem menuLang = new JMenuItem("Language");
        mnuHelp.add(menuHelp);
        mnuHelp.add(menuVerInfo);
        mnuHelp.add(menuLang);

        menuVerInfo.addActionListener(new ActionListener() {
            // VerInfo Action
            JFrame owner;

            @Override
            public void actionPerformed(ActionEvent e) {
                // VerInfoが押下されたので、ダイアログを表示
                InfoDialog dlg = new InfoDialog(owner);
                dlg.setModal(true);
                dlg.setVisible(true);
            }
        });

    }

    /**
     * メインメニューバーの構成
     *
     */
    private void createMainItem() {
        mnuFile = new JMenu("File");
        mnuEdit = new JMenu("Edit");
        mnuTool = new JMenu("Tool");
        mnuHelp = new JMenu("Help");
    }

    /**
     * メインメニューのアイテムをセット
     *
     */
    private void setMainItem() {
        menubar.add(mnuFile);
        menubar.add(mnuEdit);
        menubar.add(Box.createRigidArea(new Dimension(20, 1)));
        menubar.add(mnuTool);
        menubar.add(Box.createHorizontalGlue());
        menubar.add(mnuHelp);
    }

    /**
     * キーボードニーモニックのセット
     *
     */
    private void setKeyboardNemonic() {
        mnuFile.setMnemonic(KeyEvent.VK_F);
        mnuEdit.setMnemonic(KeyEvent.VK_E);
        mnuTool.setMnemonic(KeyEvent.VK_T);
        mnuHelp.setMnemonic(KeyEvent.VK_H);

    }
}
