/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package android.i18n;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/**
 *
 * @author nobuo
 */
public class ItemDialog extends JDialog {

    JTable table;
    JScrollPane scroll;
    DefaultTableModel model;
    JCheckBox ckbox;
    JComboBox combo;
    JLabel nodelabel;
    JButton addbtn;
    JButton delbtn;
    JButton insbtn;
    Object[] data = {"", "", ""};
    
    public ItemDialog(Frame owner, String srow) {
        super(owner);
        int ItemCOL = 2;
        setTitle("Item Add Dialog");
        setSize(400, 256);
        setLocationRelativeTo(null);
        setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
        // ダイアログに表示するコンポーネントを設定
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(FlowLayout.LEFT);
        JPanel northPanel = new JPanel(layout);
        JPanel southPanel = new JPanel(layout);

        ckbox = new JCheckBox();
        ckbox.setText("item");
        northPanel.add(ckbox);

        String[] combodata = {"Array", "Plurals"};
        combo = new JComboBox(combodata);
        northPanel.add(combo);
        CheckComboBox();
        ckbox.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                // チェックされたら、コンボボックスを有効に
                CheckComboBox();
                ChangeItem();
            }
        });
        nodelabel = new JLabel("");
        northPanel.add(nodelabel);
        combo.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                ChangeItem();

            }

        });
        
        int rrow = Integer.valueOf(srow) + 1;
        JLabel rowlabel = new JLabel("row : " + rrow);
        southPanel.add(rowlabel);
        addbtn = new JButton("add");
        southPanel.add(addbtn);
        insbtn = new JButton("ins");
        southPanel.add(insbtn);
       
        delbtn = new JButton("del");
        southPanel.add(delbtn);
        delbtn.setEnabled(false);

        Container cPane = getContentPane();
        cPane.add(northPanel, BorderLayout.NORTH);
        cPane.add(southPanel, BorderLayout.SOUTH);

        addbtn.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                // add が押下されたので、行を追加
                model.addRow(data);
                if(table.getRowCount() > 1){
                    delbtn.setEnabled(true);
                }
            }
        });
        
        insbtn.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                // add が押下されたので、行を追加
                int r = table.getEditingRow();
                model.insertRow(table.getSelectedRow(), data);
                if(table.getRowCount() > 1){
                    delbtn.setEnabled(true);
                }
                table.changeSelection(r, table.getEditingColumn(), false, false);
            }
        });
         
        delbtn.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                // del が押下されたので、行を削除
                model.removeRow( table.getSelectedRow());
                if(table.getRowCount() == 1){
                    delbtn.setEnabled(false);
                }
                table.changeSelection(0, table.getEditingColumn(), false, false);
            }
        });

        model = new DefaultTableModel(1, 1 + ItemCOL);
        table = new JTable(model);
        scroll = new JScrollPane(table);
        this.add(scroll, BorderLayout.CENTER);
        JTableHeader jh = table.getTableHeader();
        jh.setReorderingAllowed(false);// テーブルの列移動を不許可にする。
        jh.setFont(new Font(jh.getFont().getFamily(), Font.BOLD, 12));
        Object[] cnames = {"name", "en", "ja"};
        TableColumnModel columnModel = table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); i++) {
            TableColumn tc = columnModel.getColumn(i);
            tc.setHeaderValue(cnames[i]);
        }
        
         
        // １セル選択可能とする
        table.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_INTERVAL_SELECTION);
        table.setCellSelectionEnabled(true);
        table.setRowSelectionAllowed(true);

        table.requestFocus();
        table.changeSelection(0, 0, false, false);

    }

    private void ChangeItem() {
        nodelabel.setText("");
        if (combo.isEnabled()) {
            if (combo.getSelectedIndex() == 0) {
                nodelabel.setText("item");
            } else {
                nodelabel.setText("quantity");
            }
        }
    }

    private void CheckComboBox() {
        // チェックされたら、コンボボックスを有効に
        if (ckbox.isSelected()) {
            combo.setEnabled(true);
        } else {
            combo.setEnabled(false);
        }
    }
}
