package android.i18n;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseAdapter;

import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

/**
 * マウスイベントリスナー<p>
 * 右クリック時のみ処理を行います。
 */
public class EditMouseListener extends MouseAdapter {
    /**
     * イベント発生元のコンポーネント
     */
    private final Component component;
    /**
     * 表示するポップアップ
     */
    JPopupMenu jpopup;

    /**
     * コンストラクタ
     *
     * @param component イベント発生元のコンポーネント
     * @param jpopup 表示するポップアップ
     */
    public EditMouseListener(Component component, JPopupMenu jpopup) {
        super();
        this.component = component;
        this.jpopup = jpopup;
    }

    /**
     * コンポーネント上でマウスボタンを押すと呼び出されます。
     *
     * @param e
     */
    @Override
    public void mousePressed(MouseEvent e) {
        /**
         * 右押下時のみ *
         */
        if (SwingUtilities.isRightMouseButton(e)) {
            // クリックされた位置にポップアップを表示
            jpopup.show(component, e.getX(), e.getY());
        }
    }
}
