/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package android.i18n;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 *
 * @author nobuo
 */
public class AccessXML {

    JTable table;
    String cDir = "xmldata\\project\\res\\values";

    public AccessXML(JTable table) {
        this.table = table;
    }

 
    /**
     * XMLファイルの読み込み
     *
     * @param file
     */
    public void read(File file) {
        try {
            // DocumentBuilderFactoryインスタンス
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            factory.setValidating(true);
            // DocumentBuilderインスタンス
            DocumentBuilder docbuilder = factory.newDocumentBuilder();
            Document document = docbuilder.parse(new File(file.toString()));
            Element rootElement = document.getDocumentElement();
//
            NodeList children = rootElement.getChildNodes();
            //root    = docbuilder.parse(file.toString());
            //showNodes(rootElement, "");

            for (int i = 0; i < children.getLength(); i++) {
                Node child = children.item(i);
                //System.out.println(child.getNodeName());
                //System.out.println(child.getNodeValue());
                String tagStr;
                String nameStr;
                String txtStr;
                if (child instanceof Element) {
                    Element childElement = (Element) child;
                    tagStr = childElement.getTagName();
                    nameStr = childElement.getAttribute("name");

                    System.out.print(tagStr);
                    System.out.print("  :  ");
                    System.out.print(nameStr);
                    System.out.print("  :  ");

                    if (tagStr.equals("plurals")) {
                        getPlurals(document);
                        NamedNodeMap nn = childElement.getAttributes();
                        for (int j = 0; j < nn.getLength(); j++) {
                            String str = nn.getNamedItem("quantity").getNodeName();
                            System.out.print(str);
                        }
                    } else {
                        txtStr = childElement.getTextContent();
                        System.out.println(txtStr);
                    }

                }
            }
        } catch (ParserConfigurationException | SAXException | IOException ex) {
            Logger.getLogger(AccessXML.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void getPlurals(Document document) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        String txtStr = "";
        String[] qtys = {"one", "two", "few", "many", "other", "zero"};
        int n = 0;
        for (String qty : qtys) {
            String location = "/resources/plurals/item[@quantity='" + qty + "']";
            try {
                Object lt = xPath.evaluate(location, document, XPathConstants.STRING);
                txtStr = (String) lt;
                if (txtStr != "") {
                    if (n == 0) {
                        System.out.println("");
                        ++n;
                    }
                    System.out.println(qty + " : " + txtStr);
                }
            } catch (XPathExpressionException ex) {
                Logger.getLogger(AccessXML.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

    }

    /**
     * XMLファイルの書き込み
     */
    public void write() {

        // ディレクトリ作成
        int cmax = table.getColumnCount();

        String xmlDir, lang;
        for (int i = 2; i < cmax; i++) {
            lang = table.getColumnModel().getColumn(i).getHeaderValue().toString();
            if ("en".equals(lang)) {
                xmlDir = cDir;
            } else {
                xmlDir = cDir + "-" + lang;
            }
            createDir(xmlDir);
            writeXML(createDoc(i), xmlDir);
        }

    }

    private int getRmax() {
        int rmax = table.getRowCount();
        String rs;
        int rx = 0;
        for (int j = 0; j < rmax; j++) {
            rs = (String) table.getModel().getValueAt(j, 1);
            if (rs == null) {
                rx = j;
                j = rmax;
            }
        }
        return rx;
    }

    private Document createDoc(int col) {

        // DocumentBuilderFactoryインスタンス
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

        Document document = null;
        try {
            // DocumentBuilderインスタンス
            DocumentBuilder docbuilder = factory.newDocumentBuilder();
            // Documentの生成
            document = docbuilder.newDocument();
        } catch (ParserConfigurationException ex) {
            Logger.getLogger(AccessXML.class.getName()).log(Level.SEVERE, null, ex);
        }

        /*
         * root要素として resources要素を生成
         */
        Element root;
        root = document.createElement("resources");
        document.appendChild(root); // ノードをDocumentに追加

        Element volume;
        int rm = getRmax();
        String ss, cs;
        /* tag pattern
         *   1 <string name="hello">hello</string> 
         *   2 <string-array name="color">
         *       <item>white</item><item>red</item>
         *     </string-array>
         *   3 <plurals name="book">
         *       <item quantity="one">one book</item>
         *       <item quantity="other">%1$d books</item></item>
         *     </plurals> 
         */
        for (int i = 0; i < rm; i++) {
            volume = document.createElement("string");
            ss = (String) table.getModel().getValueAt(i, 1);
            volume.setAttribute("name", ss);
            cs = (String) table.getModel().getValueAt(i, col);
            if (cs == null) {
                cs = ss;
            }
            volume.appendChild(document.createTextNode(cs));
            root.appendChild(volume);
        }

        return document;

    }

    /*
     * DOMオブジェクトをファイルとして出力
     */
    private void writeXML(Document document, String fdir) {
        if (document != null) {
            FileOutputStream fos = null;
            try {
                TransformerFactory tfactory = TransformerFactory.newInstance();
                // スペース2個分のインデント
                tfactory.setAttribute("indent-number", 2);
                Transformer transformer = tfactory.newTransformer();
                transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
                transformer.setOutputProperty(OutputKeys.METHOD, "xml");
                // インデントを行う
                transformer.setOutputProperty(OutputKeys.INDENT, "yes");

                // ファイルを保存
                fos = new FileOutputStream(fdir + "\\string.xml");
                OutputStreamWriter osw = new OutputStreamWriter(fos);
                PrintWriter outfile = new PrintWriter(new BufferedWriter(osw));
                transformer.transform(new DOMSource(document), new StreamResult(outfile));

            } catch (FileNotFoundException | TransformerException ex) {
                Logger.getLogger(AccessXML.class.getName()).log(Level.SEVERE, null, ex);
            } finally {
                try {
                    fos.close();
                } catch (IOException ex) {
                    Logger.getLogger(AccessXML.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private void createDir(String targetDir) {
        //Fileオブジェクトを生成する
        File f = new File(targetDir);

        if (!f.exists()) {
            //フォルダ作成実行
            f.mkdirs();
            //System.out.println("フォルダを作成しました。");
        } else {
            // System.out.println("フォルダは既に存在します。");
        }

    }

}
