package uriagesum;

import java.util.Comparator;

/**
 *
 * @author ishimizu
 */
public class UriageComparator implements Comparator<UriageData> {

    private final int order = 1;  // 1:昇順  -1:降順

    @Override
    public int compare(UriageData u1, UriageData u2) {
        int comp = compareString(u1.getBranchCode(), u2.getBranchCode());
        if (comp == 0) {
            comp = compareString(u1.getBrandCode(), u2.getBrandCode());
        }
        return comp * order;
    }

    private int compareString(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        } else if (s1 == null) {
            return -1;
        } else if (s2 == null) {
            return 1;
        } else {
            return s1.compareTo(s2);
        }
    }

}
