# -*- mode: perl; coding: utf-8 -*-
# Copyright (c) 2003-2008 Jun Morimoto <morimoto@mrmt.net>
# This program is covered by the GNU General Public License 2
use strict;
use warnings;
use Test::More 'no_plan';
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
	use_ok('Keitairc::Config');
}

use Cwd;
use Keitairc::Log;

can_ok('Keitairc::Config', qw/new file/);

my $version = '10.1';
my $c = new Keitairc::Config({
	version => $version,
	silent => 1,
	argv => ["$FindBin::Bin/02_Config/dot.keitairc"]
		     });
isa_ok($c, 'AppConfig');
is($c->version(), $version, 'version');
is($c->irc_desc(), 'Andre Limmoenman', 'irc_desc');
is($c->irc_port(), 6667, 'irc_port');
is($c->irc_nick(), 'adr', 'irc_nick');
is($c->irc_username(), 'andre', 'irc_username');
is($c->irc_server(), 'irc.example.com', 'irc_server');
is($c->irc_password(), 'javel', 'irc_password');
is($c->irc_charset(), 'iso-2022-jp-1', 'irc_charset');
is($c->web_host(), 'your-keitairc-server.example.com', 'web_host');
is($c->web_port(), 8080, 'web_port');
is($c->web_password(), '1234', 'web_password');
is($c->web_title(), 'keitairc', 'web_title');
is($c->web_lines(), 100, 'web_lines');
is($c->web_root(), '/', 'web_root');
is($c->web_charset(), 'shiftjis', 'web_charset');
is($c->ping_delay(), 30, 'ping_delay');
is($c->reconnect_delay(), 10, 'reconnect_delay');
is($c->cookie_ttl(), 86400 * 3, 'cookie_ttl');
is($c->session_ttl(), 60 * 30, 'session_ttl');
is($c->pid_dir(), '/var/run', 'pid_dir');
is($c->pid_file(), 'keitairc.pid', 'pid_file');
is($c->plugin_dir(), '/usr/share/keitairc/lib/plugins', 'plugin_dir');
is($c->template_dir(), '/usr/share/keitairc/lib/templates', 'template_dir');
is($c->public_dir(), '/usr/share/keitairc/lib/public', 'public_dir');
is($c->fontsize(), '+0', 'fontsize');
is($c->mobile_fontsize(), -1, 'mobile_fontsize');
ok($c->reverse_message(), 'reverse_message');
ok($c->reverse_recent(), 'reverse_recent');
ok($c->reverse_unread(), 'reverse_unread');
ok($c->show_joinleave(), 'show_joinleave');
ok($c->follow_nick(), 'follow_nick');
ok(!$c->debug(), 'debug');
exit;
