/*
 -*- mode: javascript; coding: utf-8 -*-

 Copyright (c) 2009 ISHIKAWA Mutsumi <ishikawa@hanzubon.jp>
 This program is covered by the GNU General Public License 2
*/

/*
現在位置を測位して <div id="map_canvas"></div> にその位置が中心に
なった google map が表示されます。

google map api 使ってるので <head> とかで

<script type="text/javascript" src="http://maps.google.com/maps/api/js?sensor=true"></script>

が必要です。
*/

var keitairc_location = '';
var keitairc_map_url = '';

function append_location(event) {
	navigator.geolocation.getCurrentPosition(function (position) {
		var latLng = new google.maps.LatLng(position.coords.latitude,
						    position.coords.longitude);

		var map = new google.maps.Map(document.getElementById("map_canvas"),
					      {zoom: 15,
					       mapTypeId: google.maps.MapTypeId.ROADMAP,
					       center: latLng});

		var marker = new google.maps.Marker({map: map,
						     position: latLng});

		var geocoder = new google.maps.Geocoder();
		geocoder.geocode({'latLng': latLng}, function(results, status) {
			if (status == google.maps.GeocoderStatus.OK) {
				var Address = '現在の地名が分かりません: 北緯 = ' + position.coords.latitude + ', 東経 = ' + position.coords.longitude;
				for(var i = 1; i < results.length; i++){
					if (results[i].types.length >= 2 && results[i].types[1] == "political") {
						Address = results[i].formatted_address.replace(/^日本/, '');
						break;
					}
				}

				keitairc_location = '現在位置: L:'+ Address;
				keitairc_map_url = '現在位置: http://maps.google.com/maps?ll=' + position.coords.latitude + ',' + position.coords.longitude + '&q=' + encodeURI(Address) + '&z=15';

				var msg;
				msg = '<span style="font-size:80%">';
				msg += '<strong>現在の場所:</strong><br />';
				msg += Address;
				msg += '</span>';

				var info = new google.maps.InfoWindow({content: msg});
				info.open(map, marker);
			} else {
				alert("地名の変換に失敗しました: エラーコード = " + status);
			}
		});
	});
}

function location_submit(form, type) {
	if (type == 'location') {
		form.m.value = keitairc_location;
	} else {
		form.m.value = keitairc_map_url;
	}

	if (form.m.value.length) {
		form.submit();
	} else {
		return false ;
	}
}
