# -*- mode: perl; coding: utf-8 -*-
# Keitairc::Log::File
#
# Copyright (c) 2010 ISHIKAWA Mutsumi <ishikawa@hanzubon.jp>
# This program is covered by the GNU General Public License 2

package Keitairc::Log::Stdio;

use Keitairc::Config;
use strict;
use warnings;

sub new {
	my ($proto, $arg) = @_;
	my $me = {};
	$me->{debug} = (defined $arg->{config} ? $arg->{config}->debug() : 0);
	bless $me;
}

sub log_access {
	my ($me, $m) = @_;
	print STDOUT "keitairc [ACCESS]: $m\n";
}

sub log_info {
	my ($me, $m) = @_;
	print STDOUT "keitairc [INFO]: $m\n";
}

sub log_error {
	my ($me, $m) = @_;
	print STDERR "keitairc [ERROR]: $m\n";
}


sub log_debug {
	my ($me, $m) = @_;
	print STDERR "keitairc [DEBUG]: $m\n" if ($me->{debug});
}

sub log_close {
	1;
}

1;
