package game.player1.one;

import static java.awt.event.KeyEvent.VK_DOWN;
import static java.awt.event.KeyEvent.VK_LEFT;
import static java.awt.event.KeyEvent.VK_RIGHT;
import static java.awt.event.KeyEvent.VK_UP;
import static java.awt.event.KeyEvent.VK_X;
import static java.awt.event.KeyEvent.VK_Z;
import game.constant.GameConstant;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;

import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

import com.haru.component.gui.MainPanel;
import com.haru.input.KeyBind;
import com.haru.input.KeyBuffer;

public class GameFrame extends JFrame implements ActionListener {
	private static final long serialVersionUID = 1L;

	public static void main(String[] args) {
		new GameFrame();
	}

	private MainPanel mainPanel1;	// mainPanel̏W܂Panel
									// thread̊Ǘs
									// actionListener


	public GameFrame() {

		// MainPanel1
		mainPanel1 = new MainPanel();
		mainPanel1.setLayout(null);
		mainPanel1.setSize(500, 600);
		getContentPane().add(mainPanel1);

		// GameFrame
		setSize(500, 600);
		setLayout(null);
		setVisible(true);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		// j[o[̒ǉ
		JMenuBar menuBar = new JMenuBar();
		getRootPane().setJMenuBar(menuBar);
		JMenu menuFile = new JMenu("Q[");
		menuFile.setMnemonic('G');
		menuBar.add(menuFile);


		JMenuItem menuOne = new JMenuItem("ЂƂ");
		menuFile.add(menuOne);
		menuOne.setMnemonic('N');
		menuOne.addActionListener(this);
		JMenuItem menuExit = new JMenuItem("I");
		menuFile.add(menuExit);
		menuExit.setMnemonic('X');
		menuExit.addActionListener(this);






	}

	public void actionPerformed(ActionEvent e) {
		JMenuItem item = (JMenuItem)e.getSource();
		System.out.println(item.getText());

		if (item.getText().equals("ЂƂ")) {

			// KeyBuffer
			KeyBind keyBind0 = new KeyBind(VK_UP, VK_DOWN, VK_LEFT, VK_RIGHT, VK_Z, VK_X);
			KeyBuffer buffer = new KeyBuffer(keyBind0, GameConstant.CONTINUOUS_ROTATE);
			this.addKeyListener((KeyListener)buffer);
			gameStart1(buffer);

		} else if (item.getText() == "I") {
//			gameEnd();
			System.exit(0);
		}
	}


	//--------------------------------------------------------------------------//
	// ЂƂ
	//--------------------------------------------------------------------------//
	private GameThread th1;
	public void gameStart1(KeyBuffer buffer) {

		if (th1 != null) {
			gameEnd1();
		}

		th1 = new GameThreadOne(mainPanel1, buffer);
		th1.start();
	}
	public void gameEnd1() {
		th1.setEnd(true);
		try {
			th1.join();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		th1 = null;
	}



}
