package com.haru.util;

import java.util.Random;

public class ArrayRandom {

	Random r;

	int[] array;

	int cnt;

	public ArrayRandom(int[] array) {
		long seed = System.currentTimeMillis(); // ݎ̃~b
		r = new Random(seed);

		this.array = array;
		cnt = 0;

		shuffle();
	}


	public int[] getArray() {
		return array;
	}

	public int getNext() {
		if (cnt == array.length) {
			cnt = 0;
			shuffle();
		}

		return array[cnt++];
	}



	private void shuffle() {

		int left, right;

		for(left = 0; left < array.length - 1; left++){
		    right = r.nextInt(array.length - left);
		    swap(left, left + right);
		}
	}
	private void swap(int left, int right) {
		int tmp = array[left];
		array[left] = array[right];
		array[right] = tmp;
	}
}
