package com.haru.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;

import com.haru.component.GameField;
import com.haru.component.NextNextField;

public class OutData2 implements Serializable {




	/**
	 *
	 */
	private static final long serialVersionUID = 1188376444985222306L;

	private int no;

	private ArrayList<ArrayList<Integer>> gameList;
	private ArrayList<ArrayList<Integer>> nextList;




	public OutData2(int no, GameField gameField, NextNextField nextField) {
		this.no = no;


		gameList = new ArrayList<ArrayList<Integer>>();
		for (int y = 0; y < gameField.getHeight(); y++) {
			ArrayList<Integer> line = new ArrayList<Integer>();
			for (int x = 0; x < gameField.getWidth(); x++) {
				line.add(gameField.getType(x, y));
			}
			gameList.add(line);
		}



		nextList = new ArrayList<ArrayList<Integer>>();
		for (int y = 0; y < nextField.getHeight(); y++) {
			ArrayList<Integer> line = new ArrayList<Integer>();
			for (int x = 0; x < nextField.getWidth(); x++) {
				line.add(nextField.getType(x, y));
			}
			nextList.add(line);
		}

	}


	public int getNo() {
		return no;
	}

	public GameField getGameField() {

		GameField gameField = new GameField();
		int y = 0;
		for (ArrayList<Integer> line : gameList) {
			int x = 0;
			for (int type : line) {
				gameField.put(type, x, y);
				x++;
			}
			y++;
		}

		return gameField;
	}


	public NextNextField getNextNextField() {
		NextNextField nextField = new NextNextField();
		int y = 0;
		for (ArrayList<Integer> line : nextList) {
			int x = 0;
			for (int type : line) {
				nextField.put(type, x, y);
				x++;
			}
			y++;
		}

		return nextField;
	}




	
	
	private void writeObject(ObjectOutputStream out) throws IOException {
		out.defaultWriteObject();
		out.writeInt(no);
		out.writeObject(gameList);
		out.writeObject(nextList);
	}
	 private void readObject(ObjectInputStream in)
	 		throws IOException, ClassNotFoundException {
		in.defaultReadObject();
		no = in.readInt();
		gameList  = (ArrayList<ArrayList<Integer>>)in.readObject();
		nextList = (ArrayList<ArrayList<Integer>>)in.readObject();


	 }





	public void init() {
		no = 0;
	}
	public boolean isReady() {
		return no != 0;
	}



}
