package lambda;

import java.util.*;

interface Function<T, R> {

    public R apply(T t);

    /**
     * Combine with another function returning a function which preforms both
     * functions.
     *
     * @param <V> Type of output objects from the combined function. May be the
     * same type as {@code <U>}.
     * @param after An additional function to be applied to the result of this
     * function.
     * @return A function which performs both the original function followed by
     * a second function.
     */
    public default <V> Function<T, V> compose(Function<? super R, ? extends V> after) {
        Objects.requireNonNull(after);
        return (T t) -> after.apply(apply(t));
    }
}

public class Main2 {
	public static void main(String[] args) {
		/* p */
		Function<Integer, Integer> f = 
			(Integer x) -> {
				System.out.println("apply1");
				return x + 2;
			};
		System.out.println(f.apply(4));

		Function<Integer, Integer> f2 = f.compose(
			(Integer x) -> {
				System.out.println("apply2");
				return x + 3;
			});
		System.out.println(f2.apply(4));
	}
}
