package com.torn.sample;

public class SimpleLambda {
	interface HelloWorld {
		void greet();
	}
	interface HelloWorld2 {
		HelloWorld greet();
	}
	

	{
		HelloWorld greeting = () -> System.out.println("Hello World!");
		greeting.greet();

		greeting = () -> System.out.println("Good Morning!");
		greeting.greet();
		greeting = new HelloWorld() { public void greet() { System.out.println("Good Morning!"); } };
		greeting.greet();


		HelloWorld2 greeting2 = () -> () -> System.out.println("Hello World!");
		(greeting2.greet()).greet();

	}

	public static void main(String... args) {
		new SimpleLambda();
	}
}