package com.torn.enemy;

import java.util.ArrayList;

public class MyEnemy {
	private static final int ATOM_WIDTH = 12;
	private static final int ATOM_HEIGHT = 12;
	private static final int OFFSET_X  = 300;
	private static final int OFFSET_Y  = 300;

	private int columns;
	private int rows;
	private ArrayList<MovableAtom> atoms;

	public MyEnemy() {
		init();
	}

	private void init() {
		columns = 5;
		rows = 5;
		atoms = new ArrayList<MovableAtom>();
		
		
		for (int x = 0; x < columns; x++) {
			for (int y = 0; y < rows; y++) {
				atoms.add(new MovableAtom(new Atom(
						x * ATOM_WIDTH + x * 10 + OFFSET_X,
						y * ATOM_HEIGHT + y * 10 + OFFSET_Y
				)));
			}
		}
	}

	public ArrayList<MovableAtom> getAtoms() {
		return atoms;
	}
}
