package com.haru.component.gui;

import game.constant.GameState;

import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import com.haru.component.GameField;
import com.haru.component.Mino;

public class BoardPanel extends FieldPanel implements MouseListener, GameState {

	private static final long serialVersionUID = 1L;

	private int state;

	public BoardPanel() {
		state = ST_INIT;
		addMouseListener(this); // debug
	}

	public void init(GameField field) {
		state = ST_GAME;
		super.init(field);
	}

	public void paint( Graphics g ){
		super.paint(g);

		if (state == ST_INIT) {
			g.drawString("Q[JnĂ ", 100, 100);
			return;
		}

		// field̕`
		draw(g);
	}




	public void mouseClicked(MouseEvent arg0) {
	}
	public void mouseEntered(MouseEvent arg0) {
	}
	public void mouseExited(MouseEvent arg0) {
	}
	public void mousePressed(MouseEvent arg0) {



		int x = arg0.getX() / unit;
		int y = arg0.getY() / unit;

		if (field.getType(x, y) == Mino.T_EMPTY) {
			field.put(Mino.T_WALL, x, y);
		} else {
			field.put(Mino.T_EMPTY, x, y);
		}
	}
	public void mouseReleased(MouseEvent arg0) {
	}
}
