package com.haru.component;



public class TetraMino extends Mino {

	// VOg
	public static final TetraMino DOT = new TetraMino(T_DOT, new int[][]{{0, 0},{ 0, 0},{0, 0}});
	public static final TetraMino I = new TetraMino(T_I, new int[][]{{1, 0},{ 2, 0},{-1, 0}});
	public static final TetraMino O = new TetraMino(T_O, new int[][]{{1, 0},{ 1,-1},{ 0,-1}});
	public static final TetraMino S = new TetraMino(T_S, new int[][]{{1,-1},{ 0,-1},{-1, 0}});
	public static final TetraMino Z = new TetraMino(T_Z, new int[][]{{1, 0},{ 0,-1},{-1,-1}});
	public static final TetraMino L = new TetraMino(T_L, new int[][]{{1, 0},{ 1,-1},{-1, 0}});
	public static final TetraMino J = new TetraMino(T_J,new int[][]{{1, 0},{-1, 0},{-1,-1}});
	public static final TetraMino T = new TetraMino(T_T, new int[][]{{1, 0},{ 0,-1},{-1, 0}});

	public static TetraMino getBlock(int type) {
		switch (type) {
		case T_I:
			return I;
		case T_O:
			return O;
		case T_S:
			return S;
		case T_Z:
			return Z;
		case T_L:
			return L;
		case T_J:
			return J;
		case T_T:
			return T;
		}

		return DOT;
	}


	//-------------------------------------------
	private int[][] info;

	private TetraMino(int type, int info[][]) {
		super(type);
		this.info = info;
	}

	// I͂̂܂܎g
	public int[][] getInfo(int turn) {

		// O͉]Ȃ
		if (getType() == T_O)
			return info;


		// pinfo̒lRs[
		int[][] p = new int[3][2];
		for (int i = 0; i < 3; i++) {
			p[i][0] = info[i][0];
			p[i][1] = info[i][1];
		}

		// p̉]
		for (int cnt = 0; cnt < turn; cnt ++) {
			for (int i = 0; i < 3; i++) {
				int tmp = p[i][0];
				p[i][0] = - p[i][1];
				p[i][1] = tmp;
			}
		}
		return p;
	}
}
