#include <stdio.h>

#define TRUE (1)
#define FALSE (0)

#define ERROR (-1)

#define ERROR_NUM (-1)
#define PLUS   (-2)
#define MINUS  (-3)
#define MULTI  (-4)
#define DEVIDE (-5)

#define MAX_NUM (10)
#define TOKEN_LENGTH (MAX_NUM + MAX_NUM - 1)

#define PRIORITY_LOW (1)
#define PRIORITY_HIGH (2)

int purseNum(char ascii);
int purseOpe(char ascii);
void dispOpe(int token);
int getOpePriority(int token);
int isOpe(int token);
void pushStack(int token);
int popStack();

int main(int argc, char* argv[]) {
	int index;
	char* inputString;

	int curNum;
	int curOpe;

	int tokenIndex;
	int inputToken[TOKEN_LENGTH];

	int rpnTokenIndex;
	int rpnToken[TOKEN_LENGTH];
	int curToken;
	int prevToken;

	int operand1;
	int operand2;
	double tmpNum;

	/* `FbN */
	if (argc != 2) {
		printf("You are wrong!");
		return 0;
	}


	/* 10+2*3/4-5+6*8*9 = ? */

	/*********************/
	/* argv[1] */
	/*********************/
	inputString = argv[1];
	tokenIndex = 0;
	prevToken = ERROR_NUM;

	for (index = 0; inputString[index] != '\0'; index++) {

		/* mF */
		curNum = purseNum(inputString[index]);
		/* ̏ꍇ */
		if (curNum != ERROR_NUM) {

			/* Ή */
			/* AĂꍇ */
			if (isOpe(prevToken) == FALSE) {
//				printf("combine %d  %d", inputToken[tokenIndex - 1], curNum);
				curNum = inputToken[tokenIndex - 1] * 10 + curNum;
//				printf(" -> %d\n", curNum);
				--tokenIndex;
			}

			inputToken[tokenIndex] = curNum;
			tokenIndex++;

			/* oȂꍇAlZqmF */
		} else {
			curOpe = purseOpe(inputString[index]);

			/* łAlZqłȂꍇ */
			if (curOpe == ERROR_NUM) {
				/* tH[}bg */
				printf("wrong ascii code!\n");
				break; /* ̏ */
			}

			/* lZq̏ꍇ */
			inputToken[tokenIndex] = curOpe;
			tokenIndex++;
		}

		if (tokenIndex >= TOKEN_LENGTH) {
			printf("too many operand!\n");
			break;
		}

		prevToken = inputToken[tokenIndex - 1];
	}

	const int tokenLength = tokenIndex;

	/****************/
	/* ͌ */
	/****************/
	printf("analyze token :\n");
	for (index = 0; index < tokenLength; index++) {
		curToken = inputToken[index];
		if (isOpe(curToken) == FALSE) {
			printf(" %d", curToken);
		} else {
			printf(" ");
			dispOpe(curToken);
		}
	}
	printf("\n");
	/****************/

	/************************************/
	/* uL@t|[hL@ɕϊ */
	/************************************/
	/* ZqƔIyhւ */
	/* Zqm̏ꍇADxEɂ΁AZqƔIyh֓ւ */
	tokenIndex = 0;
	rpnTokenIndex = 0;

	/* ЂƂ߂͐̂͂ */
	curToken = inputToken[tokenIndex++];
	rpnToken[rpnTokenIndex++] = curToken;
	prevToken = curToken;

	do {
		curToken = inputToken[tokenIndex]; /* curToken͐Zq */
//		printf("current %d, prev %d\n", curToken, prevToken);

		/* ̏ꍇ */
		if (isOpe(curToken) == FALSE) {
			/* PÕg[N(ϊ)Zq̏ꍇAEւ */
			if (isOpe(prevToken) == TRUE) {
				rpnToken[rpnTokenIndex] = rpnToken[rpnTokenIndex - 1];
				rpnToken[rpnTokenIndex - 1] = curToken;
//				printf("switched %d <--> %c\n", rpnToken[rpnTokenIndex - 1], rpnToken[rpnTokenIndex]);
			} else {
				/* ꍇ͂̂܂܊i[ */
				rpnToken[rpnTokenIndex] = curToken;
			}
			rpnTokenIndex++;
		/* Zq̏ꍇ */
		} else {
			/* PÕg[N(ϊ)Zq̏ꍇ */
			if (isOpe(prevToken) == TRUE) {
				/* ẺZqDxꍇAZq̓ւ + ЂƂE̐2̉Zq̍ɎĂ */
				if (getOpePriority(curToken) == PRIORITY_HIGH) {
					rpnToken[rpnTokenIndex] = rpnToken[rpnTokenIndex - 1];
					rpnToken[rpnTokenIndex - 1] = curToken;
//					printf("switched %c <-> %c\n", rpnToken[rpnTokenIndex - 1], rpnToken[rpnTokenIndex]);
					rpnTokenIndex++;

					/* ЂƂg[Nǂ*/
					if ((++tokenIndex) >= tokenLength) {
						printf("format error!\n");
						break;
					}
					curToken = inputToken[tokenIndex];
//					printf(">>current %d\n", curToken);
					/* Ȃ͂ */
					if (isOpe(curToken) == TRUE) {
						printf("format error???\n");
						break;
					}
					rpnToken[rpnTokenIndex] = rpnToken[rpnTokenIndex - 1];
					rpnToken[rpnTokenIndex - 1] = rpnToken[rpnTokenIndex - 2];
					rpnToken[rpnTokenIndex - 2] = curToken;
//					printf("switched %d <-> (%c %c)\n", rpnToken[rpnTokenIndex - 2], rpnToken[rpnTokenIndex - 1], rpnToken[rpnTokenIndex]);
				} else {
					rpnToken[rpnTokenIndex] = curToken;
				}

			} else {
				rpnToken[rpnTokenIndex] = curToken;
			}
			rpnTokenIndex++;
		}

		prevToken = rpnToken[rpnTokenIndex - 1];
	} while ((++tokenIndex) < tokenLength);

	/****************/
	/* ϊʕ\ */
	/****************/
	printf("RPN token :\n");
	for (index = 0; index < tokenLength; index++) {
		curToken = rpnToken[index];
		if (isOpe(curToken) == FALSE) {
			printf(" %d", curToken);
		} else {
			printf(" ");
			dispOpe(curToken);
		}
	}
	printf("\n");
	/****************/
	for (index = 0; index < tokenLength; index++) {
		curToken = rpnToken[index];
		/* ̏ꍇAX^bNɐς */
		if (isOpe(curToken) == FALSE) {
			pushStack(curToken);
		/* Z̏ꍇAX^bN2oAZAX^bNɐς */
		} else {
			operand2 = popStack();
			operand1 = popStack();

			switch(curToken) {
			case PLUS:
				curToken = operand1 + operand2;
				break;
			case MINUS:
				curToken = operand1 - operand2;
				break;
			case MULTI:
				curToken = operand1 * operand2;
				break;
			case DEVIDE:
				if (operand2 == 0) {
					printf("devide by zero!!\n");
					return 0;
				}
				curToken= operand1 / (double)operand2 + 0.5; /* [͎ľܓ */
				break;
			default:
				curToken = 0;
				break;
			}

			pushStack(curToken);
		}
	}

	/****************/
	/* Zʕ\ */
	/****************/
	curToken = popStack();
	printf("answer : %d\n", curToken);
	/****************/

	return 0;
}

/* ̃AXL[R[hɑΉ0`9̐Ԃ */
/* 0`9̐ȊȌꍇAُl(ERROR_NUM)Ԃ */
int purseNum(char ascii) {
	int num = ascii - '0';
	if (num < 0 || num > 10) {
		return ERROR_NUM;
	}
	return num;
}

/* AXL[R[h'+','-','*','/'ꍇAZqɊ蓖ĂԍԂ */
/* (蓖ĂĺA-1ȊO̐̕Ƃ邱ƂŁAƂԂȂ悤ɂ) */
/* lZqȊȌꍇAُl(ERROR_NUM)Ԃ */
int purseOpe(char ascii) {
	int ope = ERROR_NUM;
	switch(ascii) {
	case '+':
		ope = PLUS;
		break;
	case '-':
		ope = MINUS;
		break;
	case '*':
		ope = MULTI;
		break;
	case '/':
		ope = DEVIDE;
		break;
	default:
		break;
	}
	return ope;
}

void dispOpe(int token) {
	char ascii = ' ';
	switch(token) {
	case PLUS:
		ascii = '+';
		break;
	case MINUS:
		ascii = '-';
		break;
	case MULTI:
		ascii = '*';
		break;
	case DEVIDE:
		ascii = '/';
		break;
	default:
		break;
	}
	printf("%c", ascii);
}

int isOpe(int token) {
	int ret = FALSE;
	switch(token) {
	case PLUS:
	case MINUS:
	case MULTI:
	case DEVIDE:
		ret = TRUE;
		break;
	case ERROR_NUM:
		ret = ERROR;
		break;
	default:
		break;
	}
	return ret;
}
int getOpePriority(int token) {
	int priority = PRIORITY_LOW;
	switch(token) {
	case MULTI:
	case DEVIDE:
		priority = PRIORITY_HIGH;
		break;
	}
	return priority;
}

/******************/
/* ZpX^bN */
/******************/
static int stack[TOKEN_LENGTH];
static int sp = TOKEN_LENGTH;

void pushStack(int token) {
	if (sp <= 0) {
		printf("stack is full!!\n");
		return;
	}
	stack[--sp] = token;
}

int popStack() {
	if (sp >= TOKEN_LENGTH) {
		printf("stack is empty!!\n");
		return ERROR;
	}
	return stack[sp++];
}
