package com.torn.tools;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

import javax.imageio.ImageIO;

public class MyImageManager {
	private static final int TILE_WIDTH = 6;
	private static final int TILE_HEIGHT = 6;

	/* IWiC[W̃[h */
	public static BufferedImage loadImage() throws FileNotFoundException, IOException {
		BufferedImage bi = ImageIO.read(new File("picturers/neko.png"));
		return bi;
	}
	
	/* C[W̕ۑ */
	private static void saveSubImage(RenderedImage img, int x, int y) throws IOException {
		ImageIO.write(img, "JPG", new File("picturers/work/neko" + x + "" + y + ".png"));
	}
	public static boolean saveTileImage() {
		try {
			BufferedImage bi = loadImage();
			int columns = bi.getWidth() / TILE_WIDTH;
			int rows = bi.getHeight() / TILE_HEIGHT;

			for (int x = 0; x < columns; x++) {
				for (int y = 0; y < rows; y++) {
					BufferedImage subImg = bi.getSubimage(TILE_WIDTH * x, TILE_HEIGHT * y,
							TILE_WIDTH,
							TILE_HEIGHT);
					
					saveSubImage(subImg, x, y);
				}
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return false;
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}
		
		return true;
	}
	public static boolean saveMonochromeImage() {
		try {
			BufferedImage bi = loadImage();
			int columns = bi.getWidth() / TILE_WIDTH;
			int rows = bi.getHeight() / TILE_HEIGHT;

			for (int x = 0; x < columns; x++) {
				for (int y = 0; y < rows; y++) {
					BufferedImage subImg = bi.getSubimage(TILE_WIDTH * x, TILE_HEIGHT * y,
							TILE_WIDTH,
							TILE_HEIGHT);
					
					/* Imageɔ */
					Graphics g = subImg.getGraphics();
					if (isBlackImage(subImg)) {
						g.setColor(Color.BLACK);
					} else {
						g.setColor(Color.WHITE);
					}
					g.fillRect(0, 0, TILE_WIDTH, TILE_HEIGHT);
					saveSubImage(subImg, x, y);
				}
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return false;
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}
		
		return true;
	}
	
	/* C[Wۂ */
	private static final int POINT_THRESHOLD = 500000000;
	public static boolean isBlackImage(BufferedImage img) {
		int w = img.getWidth();
		int h = img.getHeight();
		
		int point = 0;
		for (int y = 0; y < h; y++) {
			for (int x = 0; x < w; x++) {
				int rgb = img.getRGB(x, y) & 0x00ffffff;
				point += rgb;
			}
		}

		// pointႢƍۂ
		if (point < POINT_THRESHOLD) {
			return true;
		}
		
		return false;
	}
	
	/********************************/
	/* C[W[h */
	/********************************/
	public static BufferedImage loadSubImage(int x, int y) throws FileNotFoundException, IOException {
		BufferedImage bi = ImageIO.read(new File("picturers/work/neko" + x + "" + y + ".png"));
		return bi;
	}
	
	private static final int TILE_COLUMNS = 200 / TILE_WIDTH;
	private static final int TILE_ROWS = 200 / TILE_HEIGHT;
	public static BufferedImage[][] loadAllSubImage() {
		BufferedImage[][] imgArray = new BufferedImage[TILE_ROWS][TILE_COLUMNS]; // int[x][y]

		try {
			for (int x = 0; x < TILE_COLUMNS; x++) {
				for (int y = 0; y < TILE_ROWS; y++) {
						imgArray[x][y] = MyImageManager.loadSubImage(x, y);
				}
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return null;
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}

		return imgArray;
	}
	
}
