package com.torn.sample;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

import javax.swing.JFrame;

import com.torn.tools.MyImageManager;

class Atom {
	double x;
	double y;
	Atom(int x, int y) {
		this.x = x;
		this.y = y;
	}
}


@SuppressWarnings("serial")
public class Main_ReadImage2 extends JFrame implements Runnable {

	public static void main(String[] args) {
		/* 쐬 */
//		MyImageManager.saveMonochromeImage();
		/* ` */
		new Thread(new Main_ReadImage2()).start();
	}
	
	private Canvas canvas;
	private Atom[][] atomArray; // ArrayList<Atom>ł悢
	private BufferedImage[][] imgArray;
	private int columns;
	private int rows;
	
	private static final int ATOM_WIDTH = 6;
	private static final int ATOM_HEIGHT = 6;
	
	public Main_ReadImage2() {
		setSize(600, 600);
		setTitle("C[W[h");
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		setLayout(null);
		setVisible(true);
		canvas = new Canvas() {
			{
				setSize(200, 200);
				setBackground(new Color(0x00_F0_FF_FF));
			}
			public void paint(Graphics g) {
				super.paint(g);
				
				for (int y = 0; y < rows; y++) {
					for (int x = 0; x < columns; x++) {
						if (null != atomArray[x][y]) {
							g.fillOval((int)atomArray[x][y].x, (int)atomArray[x][y].y, ATOM_WIDTH, ATOM_HEIGHT);
						}
					}
				}
			}
		};
		getContentPane().add(canvas);
		initImage();
	}

	public void run() {
		while (true) {
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}
	
	
	public void initImage() {
		imgArray = MyImageManager.loadAllSubImage();
		columns = imgArray.length;
		rows = imgArray[0].length;
		atomArray = new Atom[columns][rows];
		
		for (int x = 0; x < columns; x++) {
			for (int y = 0; y < rows; y++) {
				if (MyImageManager.isBlackImage(imgArray[x][y])) {
					atomArray[x][y] = new Atom(x * ATOM_WIDTH, y * ATOM_HEIGHT);
				}
			}
		}
	}
}