package com.torn.game;
import javax.swing.JFrame;

import com.torn.enemy.AtomMoveManager;
import com.torn.player.PlayerManager;
import com.torn.tools.MyGraphics2D;


@SuppressWarnings("serial")
public class Main extends JFrame implements Runnable {
	/* LoX̃TCY */
	private static final int SIZE = 600;

	private MyCanvas canvas;

	public static void main(String[] args) {
		new Thread(new Main()).start();
	}

	public Main() {
		setTitle("toy");
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		setSize(SIZE + 20, SIZE + 40);
		setLayout(null);
		setVisible(true);
		canvas = new MyCanvas(SIZE, SIZE);
		getContentPane().add(canvas);

		initialize();
	}

	private AtomMoveManager atomController;
	private PlayerManager playerController;
	private void initialize() {
		/* S(0,0)ɕsړGraphicso^ */
		MyGraphics2D.getInstance().registGraphics(canvas.getGraphics(), SIZE / 2, SIZE / 2);

		/* Atom */
		atomController = AtomMoveManager.getInstance();
		atomController.initAtom();

		/* Player */
		playerController = PlayerManager.getInstance();
	}

	/********************************************/
	/* Q[[v(vC[ƓG̈ړEXV) */
	/* `̐Ӗ͂Ȃ                       */
	/********************************************/
	private static int gameCount = 0;
	public void run() {
		while(true) {
			/* Player */
			playerController.update();

			/* Atom */
			if (gameCount % 1000 == 0) {
				atomController.move();
			}

			try {
				Thread.sleep(1000 / 60);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			gameCount++;
		}
	}
}
