package com.torn.daydream;

import android.service.dreams.DreamService;
import android.util.Log;
import android.view.MotionEvent;
import android.widget.Toast;

public class MyDream extends DreamService {
	
	private MainView view;
	
	@Override
	public void onAttachedToWindow() {
		super.onAttachedToWindow();
		
		// Exit dream upon user touch
		setInteractive(true);
		// Hide system UI
		setFullscreen(true);
		// Set the dream layout
//		setContentView(R.layout.activity_main);
		view = new MainView(getApplicationContext());
		setContentView(view);
	}

	@Override
	public void onDreamingStarted() {
		Toast.makeText(this.getApplicationContext(), "onDreamingStarted()",
				Toast.LENGTH_SHORT).show();
	}

	@Override
	public void onDreamingStopped() {
		Toast.makeText(this.getApplicationContext(), "onDreamingStarted()",
				Toast.LENGTH_SHORT).show();
	}

	@Override
	public void onDetachedFromWindow() {
		Toast.makeText(this.getApplicationContext(), "onDetachedFromWindow()",
				Toast.LENGTH_SHORT).show();
	}
	
	@Override
	public boolean dispatchTouchEvent(MotionEvent event) {
		if (event.getAction() == MotionEvent.ACTION_DOWN) {
			float x = event.getX();
			float y = event.getY();
			Log.v("touch", "x:" + x + " y:" + y);
			
			/* Ϗ(炢) */
			view.onTouch(view, event);
		}
		return true;
	}
}
