package com.torn.enemy;

import java.util.ArrayList;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;

public class AtomMoveManager {
	private static AtomMoveManager atomManager = new AtomMoveManager();
	private ArrayList<MovableAtom> atoms = new ArrayList<MovableAtom>();

	private AtomMoveManager() {
		
	}

	public static AtomMoveManager getInstance() {
		return atomManager;
	}

	public void addAtom(float x, float y) {
		atoms.add(new MovableAtom(new Atom(x, y)));
	}
	public void addAllAtom(ArrayList<MovableAtom> array) {
		atoms.addAll(array);
	}

	public int getSize() {
		return atoms.size();
	}

	/* `NXɕKvȏ̂ݓn */
	public Point getAtomPoint(int index) {
		if (index >= atoms.size()) {
			return null;
		}
		Atom atom = atoms.get(index).getAtom();
		Point p = new Point((int)(atom.x + 0.5), (int)(atom.y + 0.5));
		return p;
	}

	public void removeAtom(int index) {
		atoms.remove(index);
	}

	/********/
	/* ` */
	/********/
	public void initAtom() {
		MyEnemy enemy = new MyEnemy();
		atoms.addAll(enemy.getAtoms());
	}

	/************/
	/* ړ */
	/************/
	public void move() {
		for (int i = 0; i < getSize(); i++) {
			moveClockwise(i);				
		}
	}

	/**********************/
	/* ړ(`) */
	/**********************/
	private static final float THETA = (float)(Math.PI / 12);

	public boolean moveClockwise(int index) {
		if (index >= atoms.size()) {
			return false;
		}

		float x, y;
		float r;
		float wt;
		float alpha;
		float dx, dy;

		/* 擾 */
		MovableAtom atom = atoms.get(index);
		x = atom.getX();
		y = atom.getY();
		r = atom.getR();
		wt = THETA * atom.t;
		alpha = atom.getAlpha();

		/* WvZ */
		dx = - r * THETA * (float)Math.sin(wt + alpha);
		dy = r * THETA * (float)Math.cos(wt + alpha);		
		atom.t++;

		/* ݒ */
		atom.setAtom(x + dx, y + dy, false);
		atoms.set(index, atom);
		
		return true;
	}
	public boolean moveAntiClockwise(int index) {
		if (index >= atoms.size()) {
			return false;
		}

		float x, y;
		float r;
		float wt;
		float alpha;
		float dx, dy;

		/* 擾 */
		MovableAtom atom = atoms.get(index);
		x = atom.getX();
		y = atom.getY();
		r = atom.getR();
		wt = THETA * atom.t;
		alpha = atom.getAlpha();
		
		/* WvZ */
		dx = - r * THETA * (float)Math.sin(wt + alpha);
		dy = r * THETA * (float)Math.cos(wt + alpha);
		atom.t--;

		/* ݒ */
		atom.setAtom(x - dx, y - dy, false);
		atoms.set(index, atom);
		
		return true;
	}

	/********/
	/* ` */
	/********/
	private static final int ATOM_RADIUS = 12;
	public void paint(Canvas canvas) {
		Paint paint = new Paint();
		
		/* ` */
		for (int i = 0; i < getSize(); i++) {
			Point p = getAtomPoint(i);
			paint.setColor(Color.CYAN);
			canvas.drawCircle(p.x, p.y, ATOM_RADIUS, paint);
		}
		
		if (!atoms.isEmpty()) {
			/* `(0Ԗڂڗ) */
			Point p = getAtomPoint(0);
			paint.setColor(Color.RED);
			paint.setStyle(Paint.Style.STROKE);
			canvas.drawCircle(p.x, p.y, ATOM_RADIUS, paint);
		}
	}

	public int getAtomRadius() {
		return ATOM_RADIUS;
	}
}