package game.net.player2;

import static java.awt.event.KeyEvent.VK_DOWN;
import static java.awt.event.KeyEvent.VK_LEFT;
import static java.awt.event.KeyEvent.VK_RIGHT;
import static java.awt.event.KeyEvent.VK_UP;
import static java.awt.event.KeyEvent.VK_X;
import static java.awt.event.KeyEvent.VK_Z;
import game.constant.GameState;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;

import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

import com.haru.component.gui.MainPanel;
import com.haru.input.KeyBind;
import com.haru.input.KeyBuffer;
import com.haru.net.NetConstant;

public class GameClientFrame1 extends JFrame implements ActionListener, GameState, NetConstant {
	private static final long serialVersionUID = 1L;


	public static void main(String[] args) {
		(new GameClientFrame1()).gameStartClient();
	}



	private static final int PANEL_W = 500;
	private static final int PANEL_H = 600;

	private MainPanel mainPanel1;
	private MainPanel mainPanel2;


	public GameClientFrame1() {

		// MainPanel1 (NCAg1)
		mainPanel1 = new MainPanel();
		mainPanel1.setLayout(null);
		mainPanel1.setSize(PANEL_W, PANEL_H);
		getContentPane().add(mainPanel1);

		// MainPanel2 (NCAg2)
		mainPanel2 = new MainPanel();
		mainPanel2.setLayout(null);
		mainPanel2.setSize(PANEL_W, PANEL_H);
		mainPanel2.setBounds(PANEL_W*1, 0, PANEL_W, PANEL_H);
		getContentPane().add(mainPanel2);



		// GameFrame
		setSize(PANEL_W*2, PANEL_H);

		setLayout(null);
		setVisible(true);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		// j[o[̒ǉ
		JMenuBar menuBar = new JMenuBar();
		JMenu menuFile = new JMenu("Q[");
		JMenuItem menuStart = new JMenuItem("X^[g");
		JMenuItem menuExit = new JMenuItem("I");

		getRootPane().setJMenuBar(menuBar);
		menuBar.add(menuFile);
		menuFile.add(menuStart);
		menuFile.add(menuExit);

		menuStart.addActionListener(this);
		menuExit.addActionListener(this);

	}

	public void actionPerformed(ActionEvent e) {
		JMenuItem item = (JMenuItem)e.getSource();
		System.out.println(item.getText());

		if (item.getText().equals("X^[g")) {
			gameStartClient();

		} else if (item.getText() == "I") {
			System.exit(0);
		}
	}

	//--------------------------------------------------------------------------//
	// NCAg
	//--------------------------------------------------------------------------//
	private GameClientThread_port threadC;

	public boolean gameStartClient() {

//		KeyBind keyBind = new KeyBind(VK_K, VK_J, VK_H, VK_L, VK_A, VK_S);
//		KeyBuffer buffer1 = new KeyBuffer( keyBind, GameConstant.CONTINUOUS_ROTATE);
		KeyBind keyBind = new KeyBind(VK_UP, VK_DOWN, VK_LEFT, VK_RIGHT, VK_Z, VK_X);
		KeyBuffer buffer2 = new KeyBuffer(keyBind, true);

		return gameStartClient(buffer2);

	}



	public boolean gameStartClient(KeyBuffer buffer) {

		// NCAg̃Xbh~߂
		if (threadC != null) {
			gameEndClient();
		}

		// ڑ
		threadC = new GameClientThread_port(mainPanel1, buffer, mainPanel2);
		if (!(threadC).connect(PORT1)) {
			return false;
		}
		threadC.start();


		this.addKeyListener((KeyListener)buffer);
		requestFocus();



		return true;

	}

	public void gameEndClient() {
		threadC.setEnd(true);
		try {
			threadC.join();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		threadC = null;
	}


}
