package com.torn.sample;
import java.awt.Graphics;

import javax.swing.JFrame;

import com.torn.enemy.AtomMoveManager;
import com.torn.player.PlayerManager;
import com.torn.tools.MyGraphics2D;


@SuppressWarnings("serial")
public class MyFrame extends JFrame implements Runnable {
	/* t[̃TCY */
	private static final int SIZE = 600;
	private static final int OFFSET = SIZE / 2;
	
	public static void main(String[] args) {
		new Thread(new MyFrame()).start();
	}
	public MyFrame() {
		setTitle("toy");
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		setSize(SIZE , SIZE );
		setVisible(true);
		
		initialize();
	}
	
	private AtomMoveManager atomController;
	private PlayerManager playerController;
	private MyGraphics2D g2;
	
	private void initialize() {
		/* Graphics */
		g2 = MyGraphics2D.getInstance();
		g2.registGraphics(this.getGraphics(), OFFSET, OFFSET);

		/* Atom */
		atomController = AtomMoveManager.getInstance();
		atomController.initAtom();
		
		/* Player */
		playerController = PlayerManager.getInstance();
//		playerController.registListener(this);
	}
	
	public void paint(Graphics g) {
		super.paint(g);

		/* Atom */
		atomController.paint();

		/* Player */
//		playerController.paint(g);
	}

	private static int gameCount = 0;
	public void run() {
		while(true) {
			/* Player */
			playerController.update();
			
			if (gameCount % 100 == 0) {
				/* Atom */
				atomController.move();
			}

			repaint();
			try {
				Thread.sleep(1000 / 5);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			gameCount++;
		}
	}
}
