package com.torn.sample;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;

import javax.swing.JFrame;

import com.torn.tools.MyImageManager;

@SuppressWarnings("serial")
public class Main_ReadImage extends JFrame implements Runnable {

	public static void main(String[] args) {

		/* 쐬 */
//		MyImageManager.saveMonochromeImage();

		/* ` */
		new Thread(new Main_ReadImage()).start();
	}
	
	private Canvas canvas;
	
	public Main_ReadImage() {
		setSize(600, 600);
		setTitle("C[W[h");
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		setLayout(null);
		setVisible(true);
		canvas = new Canvas() {
			{
				setSize(200, 200);
				setBackground(new Color(0x00_F0_FF_FF));
			}
			public void paint(Graphics g) {
				super.paint(g);
				
				for (int y = 0; y < TILE_ROWS; y++) {
					for (int x = 0; x < TILE_COLUMNS; x++) {
						g.drawImage(imgArray[x][y], TILE_WIDTH * x, TILE_HEIGHT * y, 6, 6, Color.WHITE, null);
					}
				}
			}
		};
			
		add(canvas);
		initImage();
	}

	public void run() {
		while (true) {
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}


	private static final int TILE_WIDTH = 6;
	private static final int TILE_HEIGHT = 6;
	private static final int TILE_COLUMNS = 200 / TILE_WIDTH;
	private static final int TILE_ROWS = 200 / TILE_HEIGHT;
	private BufferedImage[][] imgArray = new BufferedImage[TILE_ROWS][TILE_COLUMNS]; // int[x][y]
	
	
	public void initImage() {
		for (int x = 0; x < TILE_COLUMNS; x++) {
			for (int y = 0; y < TILE_ROWS; y++) {
				try {
					imgArray[x][y] = MyImageManager.loadSubImage(x, y);
				} catch (FileNotFoundException e) {
					e.printStackTrace();
					return;
				} catch (IOException e) {
					e.printStackTrace();
					return;
				}
			}
		}
	}
	
}