#!/usr/bin/python
# -*- coding:utf-8 -*-

import json

class Lexi(dict):
    def __init__(self, rule_file):
        self.append(rule_file)

    def append(self, rule_file):
        f = open(rule_file, "r")
        self.deep_update(json.load(f, "utf-8"))
        f.close()

    def deep_update(self, d):
        self._r_deep_update(d, self)
            
    def _r_deep_update(self, frm, dest):
        for k in frm.keys():
            if not k in dest:
                dest[k] = frm[k]
                continue
            if isinstance(frm[k], dict):
                if isinstance(dest[k], dict):
                    self._r_deep_update(frm[k], dest[k])
                    continue
                raise Exception('key %s did not match: %s v.s. %s' % (k, frm[k], dest[k]))
            dest[k] = frm[k]
