
var electron = require('electron');
var app = electron.app;
var BrowserWindow = require('browser-window');
var url = require('url');
var authInfo = require('./.account.json');
var models = require('./model/models.js');

var mainWindow = null;

function createWindow (url) {
  mainWindow = new BrowserWindow({width: 400, height: 800});
  if (client) {
    mainWindow.client = client;
  }
  if (url) {
    mainWindow.loadURL(url);
  } else {
    mainWindow.loadURL('file://' + __dirname + '/view/index.html');
  }

  mainWindow.on('closed', function() {
    mainWindow = null;
  });
}

app.on('ready', function() {
  //createWindow();
  var client = models.createClient(authInfo);
  var protocol = electron.protocol;
  protocol.registerFileProtocol('sprnkr', function (req, callback) {
    // req.url is 'sprnkr://token?oauth_token=***&oauth_verifier=***'
    var u = url.parse(req.url, true);
    var token = u.query.oauth_token;
    var verifier = u.query.oauth_verifier;
    client.authorize(token, verifier, function (err) {
      if (err) throw err;
      app._clients = [client];
      createWindow();
    });
  });

  if (client.loadTokens()) {
    app._clients = [client];
    createWindow();
  } else {
    client.getCallbackUrl(function(err, authUrl) {
      createWindow(authUrl);
    });
  } 
});

app.on('window-all-closed', function() {
  if (process.platform != 'darwin')
    app.quit();
});

app.on('activate', function () {
  if (mainWindow === null) {
    createWindow();
  }
});

