#!/usr/bin/python
# -*- coding: utf-8 -*-

import xmlrpclib
import sys
import ssl

HOST_PATH = 'mag.osdn.jp/xmlrpc.php'
#HOST_PATH = 'osdn.jp/magazine/xmlrpc.php'

import xmlrpclib

class CookieTransport(xmlrpclib.SafeTransport):
    cookies = []

    def send_cookies(self, connection):
        if self.cookies:
            for cookie in self.cookies:
                connection.putheader("Cookie", cookie)

    def request(self, host, handler, request_body, verbose=0):
        self.verbose = verbose
        h = self.make_connection(host)

        self.send_request(h, handler, request_body)
        self.send_host(h, host)
        self.send_cookies(h)
        self.send_user_agent(h)
        self.send_content(h, request_body)

        response = h.getresponse()

        print response.status
	for hv in response.getheaders():
                print hv[0] + ": " + hv[1]
        #print response.read()
        for header in response.msg.getallmatchingheaders("Set-Cookie"):
            val = header.split(": ", 1)[1]
            cookie = val.split(";", 1)[0]
            self.cookies.append(cookie)

        return self.parse_response(response)

class MagClient(object):
    def __init__(self, username, password, auth_user="", auth_pass=""):
        self.username = username
        self.password = password
        if auth_user and auth_pass:
#            self.uri = "http://{username}:{password}@{url}".format(username=auth_user, password=auth_pass, url=HOST_PATH)
            self.uri = "https://%s:%s@%s" % (auth_user, auth_pass, HOST_PATH)
        else:
            self.uri = "https://" + HOST_PATH

    def _get_blog_id(self):
        try:
            return self._blog_id
        except AttributeError:
            blogs = self.get_users_blogs()
            self._blog_id = blogs[0]["blogid"]
            return self._blog_id

    def _get_proxy(self):
        c = CookieTransport();
        #c.cookies.append("proxy_pass=1")
        c.cookies.append("wordpress_logged_in=1")
        return xmlrpclib.ServerProxy(self.uri, transport=c)

    def get_user(self, user_id, fields=[]):
        proxy = self._get_proxy()
        return proxy.wp.getUser(self._get_blog_id(),
                                self.username,
                                self.password,
                                user_id,
                                fields)

    def new_post(self, content):
        proxy = self._get_proxy()
        return proxy.wp.newPost(self._get_blog_id(),
                                self.username,
                                self.password,
                                content)

    def get_users_blogs(self):
        proxy = self._get_proxy()
        return proxy.wp.getUsersBlogs(self.username, self.password)

    def get_posts(self, filter={}):
        proxy = self._get_proxy()
        try:
            #return proxy.wp.getPosts(self._get_blog_id(),
            return proxy.wp.getPosts(1,
                                     self.username,
                                     self.password,
                                     filter)
        except xmlrpclib.Fault, e:
#            print "error {0}: {1}".format(e.faultCode, e.faultString.encode('utf8'))
            print "error %s: %s" % (e.faultCode, e.faultString.encode('utf8'))
