const testDb = {}; 

// データベース名とオブジェクトストア名を指定する
testDb.DB_NAME = "knowledge_push_example";
testDb.STORE_NAME = "messages";

// オブジェクトストアの作成用イベントハンドラ
testDb.createStore = function (event) {
  const db = event.target.result;
  const store = db.createObjectStore(testDb.STORE_NAME, { autoIncrement: true });
  console.log(`object store ${testDb.STORE_NAME} created.`);;
  // 初期データを追加する
  store.add("Initial message");
}

testDb.addMessage = function (message) {
  // 非同期処理を行うのでPromiseを返す
  return new Promise((resolve, reject) => {
    // DBに接続する
    const openReq = indexedDB.open(this.DB_NAME);

    // エラー時はrejectする
    openReq.addEventListener("error", event => {
      reject(event);
    });

    // 新規作成時にオブジェクトストアを作成する
    openReq.addEventListener("onupgradeneeded", this.createStore);

    // 接続に成功したらメッセージをDBに格納する
    openReq.addEventListener("success", event => {
      // トランザクションの作成
      const db = event.target.result;
      const transaction = db.transaction([this.STORE_NAME], "readwrite");

      // エラー時はrejectする
      transaction.addEventListener("error", event => {
        reject(event);
      });

      // メッセージを追加
      const store = transaction.objectStore(this.STORE_NAME);
      const addReq = store.add(message);
      addReq.addEventListener("success", event => {
        resolve(event);
      });
    });
  });
};

// データベースからメッセージを取得する
testDb.getMessages = function () {
  // 非同期処理を行うのでPromiseを返す
  return new Promise((resolve, reject) => {
    // DBに接続する
    const openReq = indexedDB.open(this.DB_NAME);

    // エラー時はrejectする
    openReq.addEventListener("error", event => {
      reject(event);
    });

    // 新規作成時にオブジェクトストアを作成する
    openReq.addEventListener("upgradeneeded", this.createStore);

    // 接続に成功したらメッセージをDBに格納する
    const result = [];
    openReq.addEventListener("success", event => {
      // トランザクションの作成
      const db = event.target.result;
      const transaction = db.transaction([this.STORE_NAME], "readwrite");

      // エラー時はrejectする
      transaction.addEventListener("error", event => {
        reject(event);
      });

      // データの取得
      const store = transaction.objectStore(this.STORE_NAME);
      const cursorReq = store.openCursor();
      cursorReq.addEventListener("success", event => {
        const cursor = event.target.result;
        if (cursor) {
          result.push(cursor.value);
          cursor.continue();
        } else {
          resolve(result);
        }
      });
    });
  });
};
