
var util = require('util');
var formatters = {};

// 表
var tableMode = {
  enter: {
    test: function (str) {
      return /^☆表/.test(str); 
    },
    action: function (str) {
      return util.format('<div class="table-caption caption">%s</div>\n<table>', str);
    }
  },
  exit: {
    test: function (str) { return /^\s*$/.test(str); },
    action: function (str) { return '</table>'; }
  },
  action: function (str) {
    str = str.replace(/^/, '<tr><td>')
      .replace(/$/, '</td></tr>')
      .replace(/\t/g, '</td><td>');
    return str;
  },
  flag: false
}

// 実行例
var execMode = {
  enter: {
    test: function (str) { return /^＊---/.test(str); },
    action: function (str) {
      return '<pre class="execution">'; 
    }
  },
  exit: {
    test: function(str) { return /^＊---/.test(str); },
    action: function(str) { return '</pre>'; }
  },
  flag: false
}

// リスト
var listMode = {
  enter: {
    test: function(str) { return /^＋---/.test(str); },
    action: function(str) { return '<pre class="list">'; }
  },
  exit: {
    test: function(str) { return /^＋---/.test(str); },
    action: function(str) { return '</pre>'; }
  },
  flag: false
}

// それ以外
var bodyMode = {
  enter: {
    test: function (str) { return true; },
    action: function (str) { return str; }
  },
  action: function (str) {
    return formatters.markupInline(str);
  },
  exit: {
    test: function (str) { return false; },
    action: function (str) { return str; }
  },
  flag: true
}

// 文
var paragraph = {
  test: function(str) { return /^　/.test(str); },
  action: function(str) { return '<p>' + str + '</p>\n'; },
  break: true,
};

// 見出し
var header1 = {
  test: function(str) { return /^■/.test(str); },
  action: function(str) { return '<h1>' + str.slice(1) + '</h1>\n'; },
  break: true,
};

var header2 = {
  test: function(str) { return /^●/.test(str); },
  action: function(str) { return '<h2>' + str.slice(1) + '</h2>\n'; },
  break: true,
};

var header3 = {
  test: function(str) { return /^○/.test(str); },
  action: function(str) { return '<h3>' + str + '</h3>\n'; },
  break: true,
};

// エンティティ化
var entitize = {
  test: function(str) { return true; },
  action: function(str) {
    str = str.replace(/&/g, '&amp;');
    str = str.replace(/</g, '&lt;');
    str = str.replace(/>/g, '&gt;');
    return str
  },
  break: false,
};

// 生データ
var raw = {
  test: function(str) { return !(/^$/.test(str)); },
  action: function(str) { return str + '<br/>'; },
  break: false,
};


formatters.modes = [execMode, listMode, tableMode, bodyMode];
formatters.converters = [
  entitize,
  paragraph,
  header1,
  header2,
  header3,
  raw
];

formatters.markupInline = function markupInline(str) {
  var converters = formatters.converters;

  for (var j = 0; j < converters.length; j++) {
    var converter = converters[j];
    if (converter.test(str)) {
      str = converter.action(str);
      if (converter.break) {
        break;
      }
    }
  }

  return str;
}

module.exports = formatters;
