//
// mobbs.js
//

// 意図しないネームスペース汚染を防ぐため関数スコープで処理を囲む
(function () {

  // トピック一覧の動的生成
  // jQuery Mobileではページがロードさせる直前にpagebeforeshowイベントが
  // 発生する
  $('#topics-list').live('pagebeforeshow', function (e, data) {
    // 取得したtopic情報からHTMLコード片を作成する
    function markup(topic) {
      var html = '<li>'
        + '<a href="/topic/' + topic.topicId + '/">'
        + '<h3>' + topic.title + '</h3>'
        + '<p>' + topic.text + '</p>'
        + '<p class="ui-li-aside">' + topic.date
        + ', by ' + topic.postBy + '</p>'
        + '</a></li>';
      return html;
    }

    // リストビューの内容をクリアする
    $('#topics-listview').empty();
    // JSONでトピック情報を取得する
    $.getJSON('/api/topics/list', null, function (topics) {
      // 取得したトピック情報をリストビューに追加していく
      for (var i = 0; i < topics.length; i++) {
        var subItem = markup(topics[i]);
        $('#topics-listview').append(subItem);
      }
      // リストビューを再描画する
      $('#topics-listview').listview('refresh');
    });
  });


// スコープ終了
}).apply(this);

