
var assert = require('assert');
var database = require('../models/database');

describe('database', function () {
  
  describe('.Topics#getLatest(start, end)', function () {
    it('can retrive some topic', function(done) {
      var topics = database.getTopics();
      topics.getLatest(1, 2, function (err, doc) {
        topics.close();
        assert(!err);
        console.log('--------');
        assert(doc.length > 0, 'Number of found items is invalid.');
        for (var i = 0; i < doc.length; i++) {
          console.log(doc[i]);
        }
        done();
        return;
      });
    });
  });

  describe('.Topics#findById(topicId)', function () {
    it('can retrive one topic', function(done) {
      var topics = database.getTopics();
      topics.findById(1, function (err, doc) {
        topics.close();
        assert(!err);
        assert(doc);
        console.log('--------');
        console.log(doc);
        done();
        return;
      });
    });
  });

  describe('.Topics#insert(topic, callback)', function () {
    it('insert new topic', function(done) {
      var topics = database.getTopics();
      var topic = {
        title: 'テストトピック',
        text: 'テスト用本文'
      };
      topics.insert(topic, function (err, topicId) {
        topics.close();
        assert(!err);
        assert(topicId !== undefined);
        done();
      });
    });
  });

  describe('.Comments#findById(commentId)', function () {
    it('can retrive one comments', function(done) {
      var comments = database.getComments();
      comments.findById(1, function (err, doc) {
        comments.close();
        assert(!err);
        console.log('--------');
        console.log(doc);
        done();
        return;
      });
    });
  });

  describe('.Comments#findById(commentId)', function () {
    it('can retrive some comments', function(done) {
      var comments = database.getComments();
      comments.findById([1, 2], function (err, docs) {
        comments.close();
        assert(!err);
        assert(docs.length == 2, 'length is ' + docs.length);
        console.log('--------');
        console.log(docs[0]);
        console.log(docs[1]);
        done();
        return;
      });
    });
  });

  describe('.Comments#insert(topicId, comment, callback)', function () {
    it('can insert comment', function(done) {
      var comments = database.getComments();
      var comment = {
        title: 'テストコメント',
        text: 'テスト用コメント本文',
      };
      comments.insert(1, comment, function (err, comment) {
        comments.close();
        assert(!err);
        assert(comment.commentId !== undefined);
        done();
      });
    });
  });

  describe('.Comments#insert(topicId, comment, callback)', function () {
    it('can insert child comment', function(done) {
      var comments = database.getComments();
      var comment = {
        title: 'テストコメント',
        text: 'テスト用コメント本文',
        parentCommentId: 2,
      };
      comments.insert(1, comment, function (err, comment) {
        comments.close();
        assert(!err);
        assert(comment.commentId !== undefined);
        assert(comment.parentCommentId === 2);
        done();
      });
    });
  });

  describe('.Comments#getCommentTree(topicId)', function () {
    it('can retrive some comment', function(done) {
      var count = 0;
      var comments = database.getComments();
      comments.getCommentTree(1, function (err, doc) {
        comments.close();
        assert(!err);
        assert(doc);
        console.log(doc);
        done();
        return;
      });
    });
  });

});



