var util = require('util');

var buffer = [];
var writable =  false;

/*
 * tweetをコンソールに出力する
 * @param {Object|Array} tweet 出力するtweet、もしくはその配列
 */
exports.write = function (tweet) {
  if (util.isArray(tweet)) {
    tweet.forEach(_write);
  } else {
    _write(tweet);
  }
};

/*
 * tweetのコンソールへの出力を再開する
 */
exports.resume = function () {
  buffer.forEach(function (data) {
    process.stdout.write(data);
  });
  buffer = [];
  writable = true;
},

/*
 * tweetのコンソールへの出力を一時停止する
 */
exports.pause = function () {
  writable = false;
}

// tweetを整形して出力する
function _write(tweet) {
  if (tweet.user === undefined) {
    return;
  }
  var name = tweet.user.name + ' (@' + tweet.user.screen_name + ')';
  var timestamp = tweet.created_at;
  var text = tweet.text;
  _push(name + ' ' + timestamp + '\n');
  _push(text + '\n');
  _push('\n');
}

// コンソールへの書き出しが許可されていれば文字列を出力し
// 許可されていなければバッファに格納する
function _push(data) {
  if (writable) {
    process.stdout.write(data);
  } else {
    buffer.push(data);
  }
};
