# filter for Image extraction
# -*- coding: utf-8 -*-

import re

re_imgtag = re.compile(ur'''<img[^>]*src=["']([^'"]*?)["'].*?>''')

def entry_filter(entry):
    # 画像を削除
    body = entry['body']
    images = []
    m = re_imgtag.search(body)
    if m:
        itr = re_imgtag.findall(body)
        for url in itr:
            images.append(url)
        body = re_imgtag.sub('', body)

    if len(images) > 0:
        if 'images' in entry:
            entry['images'].extend(images)
        else:
            entry['images'] = images
    entry['body'] = body

    return entry

