#!/usr/bin/python

from config import config as config, target_rss as target_rss
import ConfigParser
import sys

def main():
    config = ConfigParser.SafeConfigParser()
    for item in target_rss:
        config.add_section(item["name"])
        config.set(item["name"], 'source', item["url"])
        config.set(item["name"], 'url', item["source_url"])
        if 'filter' in item:
            filters = ",".join(item["filter"])
            config.set(item["name"], 'filters', filters)
    config.write(sys.stdout)

if __name__ == '__main__':
    main()


