
var Bing = Microsoft.Maps;
var mapCredential = 'AvVtoL6WVsQzl-3kfAoxAPR9gnJ_yh5TS6Pf0T59fMrzv86oq2qRRz5jWXqC7kWe';
var map; 
$(document).ready(docReady);

function docReady() {
    loadMap();
    $('#search_form').submit(doSearch);
    pinsInfo = new Array();
    subDistances = new Array();
	data = {pub_id: pub_id};
	$.post("/loadpins/", data, loadPinsCallback, "json");
}

function loadPinsCallback(data) {
	for (var i = 0; i < data.length; i++) {
		loc = new Bing.Location(data[i]["latitude"], data[i]["longitude"]);
		var pinIndex = pinsInfo.length + 1;
        var pushpin = new Microsoft.Maps.Pushpin(loc, {text:String(pinIndex)});
        map.entities.push(pushpin);

		var dist;
		if (pinsInfo.length > 0) {
			var lastPin = pinsInfo[pinsInfo.length-1];
			dist = calcDistance(lastPin.getLocation(), loc);
			subDistances.push(dist)
			calcTotalDistance();
		} else {
			dist = ""
		}
		pinsInfo.push(pushpin);
		var lat = loc.latitude;
		var lon = loc.longitude;
		var html = '<tr><td>' + pinIndex
			+ "</td><td>" + lat
			+ "</td><td>" + lon
			+ "</td><td>" + dist
			+ "</td></tr>";
		$('#pins_list tbody').append(html);
	}
}

function calcTotalDistance() { 
    var total = 0.0;
    for (var i = 0; i < subDistances.length; i++) {
		total += subDistances[i];
    }
    $('#total_result').text(total);
}

function calcDistance(Loc1, Loc2) { 
    var lat1 = Loc1.latitude;
    var lon1 = Loc1.longitude;
    var lat2 = Loc2.latitude;
    var lon2 = Loc2.longitude;
    var latDif = Math.PI / 180 * (lat2 - lat1);
    var lonDif = Math.PI / 180 * (lon2 - lon1);
    var vertDist = 6378.137 * latDif;
    var horzDist = Math.cos(Math.PI / 180 * lat1) * 6378.137 * lonDif;
    var dist = Math.sqrt(vertDist*vertDist + horzDist*horzDist);

    return dist;
}

function loadMap() {
    map = new Bing.Map($('#map_body')[0], {
		credentials: mapCredential,
		center: new Bing.Location(35.69, 139.7),
		zoom: 12,
		mapTypeId:Microsoft.Maps.MapTypeId.road
	});
}

function doSearch() {
    map.getCredentials(callSearchService);  
    return false;
}

function callSearchService(credentials) {
    var reqUrl = 'http://dev.virtualearth.net/REST/v1/Locations/'
    var data = {
		query: $('#query_text').val(),
		key: credentials,
    }
    $.ajax({
        type: "GET",
        url: reqUrl,
        dataType: "jsonp",
        data: data,
        jsonp: "jsonp",
        success: function (data, dataType) {
            searchCallback(data);
        }
    });
}

function searchCallback(resp) {
    if (resp &&
        resp.resourceSets &&
        resp.resourceSets.length > 0 &&
        resp.resourceSets[0].resources &&
        resp.resourceSets[0].resources.length > 0) {

        var bbox = resp.resourceSets[0].resources[0].bbox;
        var viewBoundaries = Microsoft.Maps.LocationRect.fromLocations(new Microsoft.Maps.Location(bbox[0], bbox[1]), new Microsoft.Maps.Location(bbox[2], bbox[3]));
        map.setView({ bounds: viewBoundaries});

    } else {
		alert("no result found or error cccured.");
    }
}

