
/*
 * GET home page.
 */

exports.index = function(req, res){
	res.render('index', { title: 'newb map' })
};

exports.published = function(req, res){
	var pub_id = req.url.replace("/published/", "");
	pub_id = pub_id.replace("/", "");

	res.render('published', {
		title: 'Express',
		pub_id: pub_id
	})
};

exports.loadpins = function(req, res){
	// load data from windows azure storage
	var pub_id = req.body.pub_id;
	var azure = require('azure');
	var client = azure.createTableService();
	var tablename = "newbmap";

	var query = azure.TableQuery.select().from(tablename);
	query = query.where('PartitionKey eq ?', pub_id);
	client.queryEntities(query, function(err, items){
		var locations = new Array();
		if (!err) {
			for (var i = 0; i < items.length; i++) {
				location = {
					latitude: items[i]["latitude"],
					longitude: items[i]["longitude"]
				};
				locations.push(location);
			}
			res.json(locations);
		} else {
			console.log("error!");
		}
	});
}

exports.publish = function(req, res){
	// generate unique id
    var S4 = function() {
        return (((1+Math.random())*0x10000)|0).toString(16).substring(1);
    };
	var pub_id = S4() + S4() + S4() + S4();
	// TODO: check is pub_id already exists.

	// save data to windows azure storage
	var azure = require('azure');
	var client = azure.createTableService();
	var tablename = "newbmap";
	for (var i = 0; i < req.body.locations.length; i++) {
		var item = {
			PartitionKey: pub_id,
			RowKey: String(i),
			latitude: req.body.locations[i].latitude,
			longitude: req.body.locations[i].longitude
		}
		client.insertEntity(tablename, item, function(){});
	}
	res.send(pub_id);
};
