#!/usr/bin/python
# -*- coding: utf-8 -*-

import json

# need mysql-connector-python, execute below:
# pip install mysql-connector-python
import mysql.connector

MYSQL_ACCOUNT = '.mysql_account.json'

def to_ascii(hash_data):
    result = {}
    for key in hash_data:
        if isinstance(hash_data[key], unicode):
            result[key.encode('utf-8')] = hash_data[key].encode('utf-8');
    return result

class Database:
    def __init__(self):
        self.account = self._get_account()

    def _get_account(self):
        fp = open(MYSQL_ACCOUNT)
        account = json.load(fp)
        fp.close()
        account = to_ascii(account)
        return account

    def connect(self, account=None):
        if account == None:
            account = self.account
        self.conn = mysql.connector.connect(**account)
        return self

    def execute(self, sql, values=()):
        cursor = self.conn.cursor()
        cursor.execute(sql, values)
        cursor.close()

    def commit(self):
        self.conn.commit()

    def query(self, sql, values=()):
#        print "----"
#        print sql
#        print values
#        print "----"
        cursor = self.conn.cursor()
        cursor.execute(sql, values)
        result = cursor.fetchall()
        cursor.close()
        return result

    def close(self):
        self.conn.close()

