#!/usr/bin/python
# -*- coding: utf-8 -*-
''' simple csv parser for IT DASHBOARD Data'''

import sys
import csv

def reader(fp):
    return Reader(fp)

def utf8_encoder(unicode_data):
    for line in unicode_data:
        yield line.encode('utf-8')

class Reader():
    def __init__(self, fp):
        self.fp = fp
        self.reader = csv.reader(utf8_encoder(fp))
        self.counter = 0;

    def next(self):
        data = self.reader.next()
        self.counter += 1
        try:
            return [x.decode('utf8') for x in data]
        except UnicodeDecodeError, e:
            for i in data:
                try:
                    i = i.decode('sjis')
                except UnicodeDecodeError:
                    print >> sys.stderr, 'illegal data:', i
                    print >> sys.stderr, 'lineno:', self.counter, self.reader.line_num
            raise e

    def __iter__(self):
        self.fp.seek(0)
        self.counter = 0
        self.reader = csv.reader(utf8_encoder(self.fp))
        return self

def test_code():
    import codecs
    f = open('test.csv')
    r = reader(f)
    for row in r:
        for i in row:
            sys.stdout.write(i)
            sys.stdout.write(', ')
        sys.stdout.write('\n')
    f.close()

