# API Reference Start Page {#mainpage}

# What is this?
This is the complete API reference for <a href="www.ogre3d.org"><b>OGRE</b></a> (<b>O</b>bject-Oriented <b>G</b>raphics <b>R</b>endering <b>E</b>ngine). Contained within are the 
specifications for each namespace/module/class and the methods from those which you can refer to when writing code which uses OGRE. 

The API references for some of the previous OGRE versions can be found under the following link: <a href="http://www.ogre3d.org/docs/api/X.Y">www.ogre3d.org/docs/api/X.Y</a> (replace X.Y with the version number, for example 1.7, 1.8, etc.).

# It's so BIG!

Yes it is (and thank you for noticing). OGRE is a large and complex 
system so the API documentation, whilst fully inclusive and the most 
complete reference to OGRE that you'll find, is not the recommended way to 
start learning. You will certainly want
to refer to this documentation once you have found your feet, and pretty soon
referring to it will become second nature. Until then, you should begin with 
more "discussive" documentation such as:

* [The Manual](@ref manual): The OGRE manual is a
general introduction to the OGRE principles and core components, and a 
reference to various important parts of the OGRE system, especially the
script syntax for materials, particle systems, and overlays.
* [The OGRE Tutorials](@ref tutorials): This is a gold mine for new and experienced users alike.

We make an effort to document our classes fully so we hope you can find what
you need here. However, if you can't find it, or you're not sure where to 
start looking, visit the <a href="http://www.ogre3d.org">main OGRE website</a> and dip into the <a href="http://www.ogre3d.org/support">community areas</a>
like the <a href="http://www.ogre3d.org/wiki">wiki</a> and the <a href="http://www.ogre3d.org/forums/">forums</a> to get some assistance. 

# License
  
The OGRE rendering engine itself is licensed under the <a href="http://opensource.org/licenses/MIT/">MIT License</a>. More details can be found <a href="http://www.ogre3d.org/licensing/">here</a>.<br>
This documentation work is licensed under a <a rel="license" href="http://creativecommons.org/licenses/by-sa/3.0/">Creative Commons Attribution-ShareAlike 3.0 Unported License</a>.<br>
*Copyright &copy; 2015 Torus Knot Software Ltd*<br>
<img alt="Creative Commons License" src="http://i.creativecommons.org/l/by-sa/3.0/88x31.png" />
