
struct VS_INPUT
{
	float3 vertex	: POSITION;
	float4 colour	: COLOR;
	float2 uv0		: TEXCOORD0;
};

struct PS_INPUT
{
	float4 color : COLOR;
	float2 uv	: TEXCOORD0;
	float4 gl_Position	: SV_Position;
};

PS_INPUT main
(
	VS_INPUT input,

	uniform matrix matWorldViewProjection
)
{
	PS_INPUT outVs;

	outVs.gl_Position	= mul( matWorldViewProjection, float4( input.vertex, 1.0 ) );
	outVs.color = input.colour;
    outVs.uv  = input.uv0;

	return outVs;
}
